/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.api.external;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.ha.http.service.api.external.base.AbstractExternalHttpHandler;
import kd.bos.ha.http.service.api.external.base.ExternalApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.eclipse.jetty.http.HttpMethod;

public class GetServiceListHandler
extends AbstractExternalHttpHandler {
    private static final Log log = LogFactory.getLog(AbstractExternalHttpHandler.class);
    private static final String PROXY_PROTOCOL = "http://";
    private static final String GET_SYSTEM_PROPERTIES = "/monitor/goldeye/systemproperties/";
    private final ForkJoinPool executor = new ForkJoinPool(3);

    @Override
    public void handle0(HttpExchange httpExchange) throws IOException {
        if (!HttpMethod.POST.name().equals(httpExchange.getRequestMethod())) {
            this.writeJson(ExternalApiResult.error(405, "The current httpMethod is not supported"), httpExchange);
            return;
        }
        HashMap<String, List<Object>> resuLtMap = new HashMap<String, List<Object>>(2);
        String propertiesStr = (String)super.getParamMap().get("properties");
        List serviceInfoList = ServiceInfoFactory.get().getServiceList();
        List<Object> resultList = new ArrayList(serviceInfoList.size());
        if (StringUtils.isNotEmpty((String)propertiesStr)) {
            resultList = this.getAllServiceProperties(serviceInfoList, propertiesStr);
        } else {
            for (ServiceInfo serviceInfo : serviceInfoList) {
                HashMap<String, ServiceInfo> lastMap = new HashMap<String, ServiceInfo>(1);
                lastMap.put("serviceInfo", serviceInfo);
                resultList.add(lastMap);
            }
        }
        resuLtMap.put("serviceInfoList", resultList);
        this.writeJson(ExternalApiResult.success(resuLtMap), httpExchange);
    }

    public List<Map<String, Object>> getAllServiceProperties(List<ServiceInfo> serviceInfoList, String paramStr) {
        List distinctAppNameList = serviceInfoList.stream().collect(Collectors.toMap(ServiceInfo::getAppName, Function.identity(), (o1, o2) -> o1)).values().stream().collect(Collectors.toList());
        CompletableFuture[] futures = new CompletableFuture[distinctAppNameList.size()];
        for (int i = 0; i < distinctAppNameList.size(); ++i) {
            int index = i;
            futures[i] = CompletableFuture.supplyAsync(() -> this.getServiceProperties((ServiceInfo)distinctAppNameList.get(index), paramStr), this.executor);
        }
        ArrayList<Map<String, Object>> allList = new ArrayList<Map<String, Object>>(serviceInfoList.size());
        ((ForkJoinTask)this.executor.submit(() -> {
            for (CompletableFuture future : futures) {
                Map map = (Map)future.join();
                String appName = null;
                Object value = null;
                for (Map.Entry entry : map.entrySet()) {
                    appName = (String)entry.getKey();
                    value = entry.getValue();
                }
                for (ServiceInfo serviceInfo : serviceInfoList) {
                    if (!serviceInfo.getAppName().equals(appName)) continue;
                    HashMap<String, ServiceInfo> lastMap = new HashMap<String, ServiceInfo>(2);
                    lastMap.put("serviceInfo", serviceInfo);
                    lastMap.put("properties", (ServiceInfo)value);
                    allList.add(lastMap);
                }
            }
            return allList;
        })).join();
        return allList;
    }

    private Map<String, Object> getServiceProperties(ServiceInfo serviceInfo, String paramStr) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(1);
        try {
            Map proxyHeader = this.getProxyHeaderMap();
            String fulUrl = this.getSystemPropertiesUrl(serviceInfo.getHostIp(), serviceInfo.getHostMonitorPort(), paramStr);
            String resultStr = EyeHttpClients.get((String)fulUrl, (Map)proxyHeader, (int)5000, (int)15000);
            Map resultMap = (Map)JSONUtils.cast((String)resultStr, Map.class);
            returnMap.put(serviceInfo.getAppName(), resultMap.get("data"));
        }
        catch (IOException e) {
            log.warn("\u5916\u90e8\u63a5\u53e3\u83b7\u53d6\u670d\u52a1\u6307\u5b9a\u5c5e\u6027\u5931\u8d25\uff0cInstanceId\uff1a" + serviceInfo.getInstanceId(), (Throwable)e);
            returnMap.put(serviceInfo.getAppName(), null);
        }
        return returnMap;
    }

    private String getSystemPropertiesUrl(String ip, String port, String paramStr) {
        return PROXY_PROTOCOL + ip + ":" + port + GET_SYSTEM_PROPERTIES + "?properties=" + paramStr;
    }
}

