/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.api.external;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.ha.http.service.api.external.base.AbstractExternalHttpHandler;
import kd.bos.ha.http.service.api.external.base.ExternalApiResult;
import kd.bos.ha.http.service.api.gracefulrestart.GracefulRestartManager;
import kd.bos.ha.http.service.api.gracefulrestart.vo.GracefulRestartForm;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.util.EnvUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.eclipse.jetty.http.HttpMethod;

public class ScrollRestartHandler
extends AbstractExternalHttpHandler {
    private static final Log log = LogFactory.getLog(ScrollRestartHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        if (!HttpMethod.POST.name().equals(exchange.getRequestMethod())) {
            this.writeJson(ExternalApiResult.error(405, "The current httpMethod is not supported"), exchange);
            return;
        }
        if (!EnvUtils.isRunningInsideContainer()) {
            this.writeJson(ExternalApiResult.error(409, "The service can only be restarted in a container environment!!"), exchange);
            return;
        }
        if (!super.getParamMap().containsKey("scrollRestartForm")) {
            this.writeJson(ExternalApiResult.error(422, "The server is unable to process the request due to missing or invalid required parameters"), exchange);
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        GracefulRestartForm gracefulRestartForm = (GracefulRestartForm)mapper.convertValue(super.getParamMap().get("scrollRestartForm"), GracefulRestartForm.class);
        CharSequence[] appNameArr = null;
        if (gracefulRestartForm != null) {
            appNameArr = gracefulRestartForm.getSelectAppNames();
        }
        if (gracefulRestartForm == null || appNameArr == null || appNameArr.length == 0) {
            this.writeJson(ExternalApiResult.error(400, "selectAppNames cannot be empty"), exchange);
            return;
        }
        if (appNameArr.length == 1 && this.getAppNameList(appNameArr[0]).isEmpty()) {
            this.writeJson(ExternalApiResult.error(400, appNameArr[0] + " does not exist or has been offline"), exchange);
            return;
        }
        boolean isSurvival = false;
        StringBuilder notExistBuffer = new StringBuilder();
        for (String string : appNameArr) {
            if (this.getAppNameList(string).isEmpty()) {
                notExistBuffer.append(string).append(",");
                continue;
            }
            isSurvival = true;
        }
        String notExistAppName = notExistBuffer.toString();
        if (!isSurvival) {
            this.writeJson(ExternalApiResult.error(400, notExistAppName + "All the services not exist or are offline, so there is no need to restart"), exchange);
            return;
        }
        StringBuilder message = new StringBuilder("Request succeeded!");
        if (StringUtils.isNotEmpty((String)notExistAppName)) {
            message.append("But ").append(notExistAppName).append(" does not exist or has been offline");
            log.warn("\u5f00\u59cb\u6eda\u52a8\u91cd\u542f,\u4f46\u662f\u90e8\u5206\u670d\u52a1{}\u5df2\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u4e0b\u7ebf", (Object)notExistAppName);
        }
        log.info("\u63a5\u6536\u5916\u90e8\u63a5\u53e3\u7684\u6eda\u52a8\u91cd\u542f\u8bf7\u6c42,\u5f00\u59cb\u6eda\u52a8\u91cd\u542f,\u91cd\u542f\u7684\u670d\u52a1\u5305\u62ec\uff1a" + String.join((CharSequence)",", appNameArr));
        super.opLog(exchange, OpType.EXECUTE, Resources.getString((String)"\u6eda\u52a8\u91cd\u542f\u63a5\u53e3", (String)"ScrollRestartHandler_0", (String)"bos-ha", (Object[])new Object[0]), Resources.getString((String)String.format("\u8c03\u7528\u6eda\u52a8\u91cd\u542f\u63a5\u53e3\u91cd\u542f\u670d\u52a1,\u91cd\u542f\u7684\u670d\u52a1\u5305\u62ec\uff1a%s", String.join((CharSequence)",", appNameArr)), (String)"ScrollRestartHandler_1", (String)"bos-ha", (Object[])new Object[0]));
        GracefulRestartManager.toRestartAllServer(gracefulRestartForm);
        this.writeJson(ExternalApiResult.success("", message.toString()), exchange);
    }

    private List<ServiceInfo> getAppNameList(String appName) {
        List serviceInfoList = ServiceInfoFactory.get().getServiceList();
        return serviceInfoList.stream().filter(serviceInfo -> serviceInfo.getAppName().equals(appName)).collect(Collectors.toList());
    }
}

