/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.api.external.base;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.oplog.OpLogEntity;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogUtil;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.ha.http.service.api.external.base.ExternalApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public abstract class AbstractExternalHttpHandler
implements HttpHandler {
    private static final Log log = LogFactory.getLog(AbstractExternalHttpHandler.class);
    private static final String PROXY_HEADER_KEY = EyeProxyHandler.PROXY_HEADER_KEY;
    private static final String PROXY_HEADER_VALUE = EyeProxyHandler.PROXY_HEADER_VALUE;
    private static final String EXTERNAL_USER = "monitor.external.account.user";
    private static final String EXTERNAL_PD = "monitor.external.account.pd";
    private static final String AUTH_KEY = "auth";
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private Map<String, Object> paramMap;

    protected abstract void handle0(HttpExchange var1) throws IOException;

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    protected Map getProxyHeaderMap() {
        HashMap<String, String> proxyHeader = new HashMap<String, String>(1);
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        return proxyHeader;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            this.paramMap = (Map)ExchangeVueUtils.parseJsonFromPost((HttpExchange)httpExchange, HashMap.class);
            if (!this.paramMap.containsKey(AUTH_KEY)) {
                this.writeJson(ExternalApiResult.error(422, "The server is unable to process the request due to missing or invalid required parameters"), httpExchange);
                return;
            }
            Map auth = (Map)this.paramMap.get(AUTH_KEY);
            String userName = (String)auth.get("username");
            String passwd = (String)auth.get("password");
            if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)passwd)) {
                log.error("auth message is null, access denied");
                this.writeJson(ExternalApiResult.error(403, "auth message is null, access denied"), httpExchange);
                return;
            }
            if (Boolean.getBoolean("monitor.external.auth.bymc") && this.checkAuthByMC(userName, passwd)) {
                this.writeJson(ExternalApiResult.error(403, "The username or password is incorrect, access denied"), httpExchange);
                return;
            }
            if (EyeAuther.checkUser((String)userName, (String)Encrypters.decode((String)passwd)) && !EyeAuther.isLocked((String)userName)) {
                if (!System.getProperty("monitor.user").equals(userName) && EyeAuther.isExpirePassword((String)userName)) {
                    this.writeJson(ExternalApiResult.error(403, "User password has expired"), httpExchange);
                    return;
                }
            } else {
                int errorTimes = this.getErrorTimes(userName);
                boolean forbidden = EyeAuther.isForbidden((String)userName);
                if (forbidden) {
                    this.writeJson(ExternalApiResult.error(403, String.format("User: %s login errors have reached %s times, and the account is locked. Please try again in 30 minutes", userName, errorTimes)), httpExchange);
                    return;
                }
                this.writeJson(ExternalApiResult.error(403, "The username or password is incorrect, access denied"), httpExchange);
                return;
            }
            if (!EyeAuther.checkPermission((String)userName, (String)httpExchange.getRequestURI().getPath())) {
                this.writeJson(ExternalApiResult.error(403, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6b64\u64cd\u4f5c\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728Monitor\u5e73\u53f0\u4e0a\u4e3a\u5f53\u524d\u7528\u6237\u5206\u914d\u64cd\u4f5c\u6743\u9650", (String)"AbstractExternalHttpHandler_0", (String)"bos-ha", (Object[])new Object[0])), httpExchange);
                return;
            }
        }
        catch (IOException e) {
            this.writeJson(ExternalApiResult.error(400, "Parameter parsing error"), httpExchange);
            return;
        }
        try {
            this.handle0(httpExchange);
        }
        catch (Exception e) {
            log.error("Monitor\u5bf9\u5916\u63a5\u53e3\u5f02\u5e38: " + httpExchange.getRequestURI().getPath(), (Throwable)e);
            String errorMessage = e.getMessage();
            this.writeJson(ExternalApiResult.error(500, StringUtils.isNotEmpty((String)errorMessage) ? errorMessage : "An unknown exception occurred"), httpExchange);
        }
    }

    protected void opLog(HttpExchange exchange, OpType opType, String opObject, String description) {
        OpLogEntity opLogEntity = new OpLogEntity();
        opLogEntity.setId(DB.genLongId((String)"T_MONITOR_OPLOG"));
        Map auth = (Map)this.paramMap.get(AUTH_KEY);
        String userName = (String)auth.get("username");
        opLogEntity.setUserName(userName);
        opLogEntity.setOpTime(LocalDateTime.now());
        opLogEntity.setClientIp(OpLogUtil.getRemoteHost((HttpExchange)exchange));
        opLogEntity.setOpType(opType.getTypeDescription());
        opLogEntity.setOpObject(opObject);
        opLogEntity.setDescription(description);
        OPLOGGER.opLog(opLogEntity);
    }

    private boolean checkAuthByMC(String userName, String passwd) {
        String user = System.getProperty(EXTERNAL_USER);
        String pd = System.getProperty(EXTERNAL_PD);
        if (StringUtils.isEmpty((String)user) || StringUtils.isEmpty((String)pd)) {
            return false;
        }
        String decode = Encrypters.decode((String)pd);
        return user.equals(userName) && decode.equals(passwd);
    }

    private int getErrorTimes(String userName) {
        String key;
        DistributeSessionableCache cache = SessionStore.get().getCache();
        String oldNum = (String)cache.get(key = "monitor-forbidden-account-" + userName, (Object)userName);
        if (StringUtils.isEmpty((String)oldNum)) {
            return 0;
        }
        return Integer.parseInt(oldNum);
    }

    protected void writeJson(ExternalApiResult result, HttpExchange exchange) throws IOException {
        String str = JSONUtils.toString((Object)result);
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }
}

