/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.api.gracefulrestart.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.ha.http.service.api.ServiceStatusManage;
import kd.bos.ha.http.service.api.gracefulrestart.strategy.RestartStrategy;
import kd.bos.ha.http.service.api.gracefulrestart.vo.GracefulRestartForm;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;
import kd.bos.util.resource.Resources;

public class AbstractRestartStrategy
implements RestartStrategy<List<ServiceInfo>, GracefulRestartForm> {
    private static final String PROXY_PROTOCOL = "http://";
    private static final String PROXY_HEADER_KEY = EyeProxyHandler.PROXY_HEADER_KEY;
    private static final String PROXY_HEADER_VALUE = EyeProxyHandler.PROXY_HEADER_VALUE;
    private static final String GRACEFUL_RESTART_URL = "/monitor/goldeye/gracefulRestart";
    private static final String QUERY_SERVICE_STATUS_URL = "/monitor/goldeye/serviceStatus";
    private static final int WAIT_RESTART_TIME = Integer.parseInt(System.getProperty("monitor.graceful.max.waitTime", "10"));
    private static final Log log = LogFactory.getLog(AbstractRestartStrategy.class);
    private static final String maxPoolCount = System.getProperty("monitor.graceful.pool.instance.max.count", "20");
    private static final ThreadPool pool = ThreadPools.newCachedThreadPool((String)"MonitorGracefulRestartInstance", (int)0, (int)Integer.parseInt(maxPoolCount));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart(List<List<ServiceInfo>> batchList, GracefulRestartForm form) {
        ServiceInfo service = null;
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        lock.lock();
        try {
            service = batchList.get(0).get(0);
            List allServiceInfos = ServiceInfoFactory.get().getServiceList();
            ServiceInfo finalService = service;
            List oldAppNameList = allServiceInfos.stream().filter(info -> info.getAppName().equals(finalService.getAppName())).collect(Collectors.toList());
            for (List<ServiceInfo> serviceInfos : batchList) {
                AtomicInteger count = new AtomicInteger(serviceInfos.size());
                for (ServiceInfo serviceInfo : serviceInfos) {
                    pool.execute(() -> {
                        if (!this.isPostRestart(serviceInfo, form)) {
                            this.doNotify(lock, condition, count);
                            return;
                        }
                        AtomicLong startTime = new AtomicLong(0L);
                        AtomicInteger restartCount = new AtomicInteger(0);
                        String queryServiceStatusUrl = this.getServiceStatusUrl(serviceInfo.getHostIp(), serviceInfo.getHostMonitorPort());
                        try {
                            log.info("\u6eda\u52a8\u91cd\u542f-\u67e5\u8be2\u670d\u52a1AppName: {} \u662f\u5426\u5df2\u7ecf\u505c\u6b62\u670d\u52a1,the url {}", (Object)serviceInfo.getAppName(), (Object)queryServiceStatusUrl);
                            Map proxyHeader = this.getProxyHeaderMap();
                            while (true) {
                                JSONObject jsonObject;
                                if (!((Boolean)(jsonObject = JSON.parseObject((String)EyeHttpClients.get((String)queryServiceStatusUrl, (Map)proxyHeader, (int)5000, (int)15000))).get((Object)"status")).booleanValue()) {
                                    this.doNotify(lock, condition, count);
                                    log.info(serviceInfo.getAppName() + "\u6eda\u52a8\u91cd\u542f-\u670d\u52a1\u72b6\u6001\u7531\u6682\u505c\u624b\u52a8\u6062\u590d\u4e3a\u6b63\u5e38,\u5f53\u524d\u670d\u52a1\u65e0\u9700\u91cd\u542f");
                                    break;
                                }
                                TimeUnit.SECONDS.sleep(5L);
                                log.info("\u6eda\u52a8\u91cd\u542f-\u6bcf5\u79d2\u5faa\u73af\u7b49\u5f85\u670d\u52a1AppName: {} \u505c\u6b62\u670d\u52a1", (Object)serviceInfo.getAppName());
                            }
                        }
                        catch (Exception e) {
                            log.warn("\u6eda\u52a8\u91cd\u542f-" + serviceInfo.getInstanceId() + "-\u5df2\u88ab\u4f18\u96c5\u505c\u6b62\uff0c\u6b63\u5728\u91cd\u542f....");
                            while (!this.isRestarted(serviceInfo.getAppName(), oldAppNameList) && !this.isGreaterWaitRestartTime(serviceInfo.getAppName(), startTime, restartCount)) {
                            }
                            this.doNotify(lock, condition, count);
                        }
                    });
                }
                while (count.get() > 0) {
                    condition.await(WAIT_RESTART_TIME + 1, TimeUnit.MINUTES);
                }
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        finally {
            lock.unlock();
            if (service != null) {
                String appName = service.getAppName();
                log.info(appName + "\u670d\u52a1\u6eda\u52a8\u91cd\u542f\u6210\u529f,\u5f00\u59cb\u5220\u9664\u4f18\u96c5\u91cd\u542f\u7684\u72b6\u6001\u6807\u5fd7...");
                ServiceStatusManage.deleteRollingRestartStatus(appName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify(Lock lock, Condition condition, AtomicInteger count) {
        try {
            lock.tryLock(3L, TimeUnit.SECONDS);
            count.getAndDecrement();
            if (count.get() == 0) {
                condition.signalAll();
            }
        }
        catch (InterruptedException e) {
            log.warn("\u6eda\u52a8\u91cd\u542f-doNotify InterruptedException", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isRestarted(String appName, List oldAppNameList) {
        try {
            TimeUnit.SECONDS.sleep(30L);
            List latestServiceInfoList = ServiceInfoFactory.get().getServiceList();
            List latestAppNameList = latestServiceInfoList.stream().filter(info -> info.getAppName().equals(appName)).collect(Collectors.toList());
            if (latestAppNameList != null && latestAppNameList.size() >= oldAppNameList.size()) {
                int serviceRegistryWaitTime = Integer.getInteger("monitor.graceful.service.registry.waitTime", 30);
                TimeUnit.SECONDS.sleep(serviceRegistryWaitTime);
                log.info("\u6eda\u52a8\u91cd\u542f-" + appName + "\u670d\u52a1\u5df2\u5728\u914d\u7f6e\u4e2d\u5fc3zk\u6ce8\u518c,\u5e76\u4e14\u5df2\u7b49\u5f85 " + serviceRegistryWaitTime + "\u79d2,\u786e\u4fdd\u670d\u52a1\u5b8c\u5168\u542f\u52a8\u5e76\u5728\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u6ce8\u518c\uff01");
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return true;
        }
    }

    private boolean isGreaterWaitRestartTime(String appName, AtomicLong startTime, AtomicInteger restartCount) {
        if (restartCount.get() == 0) {
            startTime.set(System.currentTimeMillis());
        }
        if (System.currentTimeMillis() - startTime.get() > (long)WAIT_RESTART_TIME * 60L * 1000L) {
            String logInfo = Resources.getString((String)String.format("\u6eda\u52a8\u91cd\u542f-%s\u670d\u52a1\u7b49\u5f85\u91cd\u542f\u65f6\u95f4\u8d85\u8fc7\u4e86%d\u5206\u949f,\u7ed3\u675f\u7b49\u5f85", appName, WAIT_RESTART_TIME), (String)"AbstractRestartStrategy_0", (String)"bos-ha", (Object[])new Object[0]);
            log.info(logInfo);
            return true;
        }
        restartCount.incrementAndGet();
        return false;
    }

    private String getGracefulRestartUrl(String ip, String port) {
        return PROXY_PROTOCOL + ip + ":" + port + GRACEFUL_RESTART_URL;
    }

    private String getServiceStatusUrl(String ip, String port) {
        return PROXY_PROTOCOL + ip + ":" + port + QUERY_SERVICE_STATUS_URL;
    }

    private boolean isPostRestart(ServiceInfo serviceInfo, GracefulRestartForm paramForm) {
        String appName = serviceInfo.getAppName();
        HashMap<String, String> proxyHeader = new HashMap<String, String>(1);
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        String gracefulRestartUrl = this.getGracefulRestartUrl(serviceInfo.getHostIp(), serviceInfo.getHostMonitorPort());
        try {
            log.info("\u6eda\u52a8\u91cd\u542f-AppName: {} start rollingRestart,the url {}", (Object)serviceInfo.getAppName(), (Object)gracefulRestartUrl);
            GracefulRestartForm gracefulRestartForm = new GracefulRestartForm();
            gracefulRestartForm.setAction("singleRestart");
            gracefulRestartForm.setCustomWaitTime(paramForm.getCustomWaitTime());
            String param = JSONUtils.toString((Object)gracefulRestartForm);
            String jsonResult = EyeHttpClients.postjson((String)gracefulRestartUrl, proxyHeader, (String)param, (int)5000, (int)20000);
            JSONObject jsonObject = JSON.parseObject((String)jsonResult);
            if (!"0".equals(String.valueOf(jsonObject.get((Object)"code")))) {
                log.info("\u6eda\u52a8\u91cd\u542f-AppName: {} restart failed,the reason is : {}", (Object)serviceInfo.getAppName(), (Object)jsonResult);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.warn("\u6eda\u52a8\u91cd\u542f-AppName: {} start rollingRestart exception,the url {}", (Object)appName, (Object)gracefulRestartUrl);
            log.warn("\u6eda\u52a8\u91cd\u542f-Start rollingRestart exception", (Throwable)e);
            return false;
        }
    }

    private Map getProxyHeaderMap() {
        HashMap<String, String> proxyHeader = new HashMap<String, String>(1);
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        return proxyHeader;
    }
}

