/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.api.gracefulrestart.strategy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.ha.http.service.api.gracefulrestart.enums.RestartType;
import kd.bos.ha.http.service.api.gracefulrestart.strategy.RestartStrategy;
import kd.bos.ha.http.service.api.gracefulrestart.strategy.impl.CustomWaitTimeRestartTime;
import kd.bos.ha.http.service.api.gracefulrestart.strategy.impl.GracefulWaitRestartStrategy;
import kd.bos.ha.http.service.api.gracefulrestart.strategy.impl.NoWaitRestartStrategy;
import kd.bos.ha.http.service.api.gracefulrestart.vo.GracefulRestartForm;

public class RestartStrategyFactory {
    private static Map<RestartType, RestartStrategy> restartStrategyMap = new ConcurrentHashMap<RestartType, RestartStrategy>(3);

    public static RestartStrategy getRestartStrategy(GracefulRestartForm paramForm) {
        RestartType type = RestartType.codeOfType(paramForm.getRestartType());
        switch (type) {
            case NO_WAIT: {
                paramForm.setCustomWaitTime(0);
                break;
            }
            case CUSTOM_WAITTIME: {
                break;
            }
            default: {
                paramForm.setCustomWaitTime(2147483);
            }
        }
        return restartStrategyMap.computeIfAbsent(type, k -> {
            switch (type) {
                case NO_WAIT: {
                    return new NoWaitRestartStrategy();
                }
                case CUSTOM_WAITTIME: {
                    return new CustomWaitTimeRestartTime();
                }
            }
            return new GracefulWaitRestartStrategy();
        });
    }
}

