/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.healthcheck;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.ha.http.service.healthcheck.HealthCheckUtils;
import kd.bos.ha.http.service.healthcheck.appcheck.AppCheck;
import kd.bos.instance.Instance;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.util.ExchangeUtils;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.trace.util.TraceIdUtil;

public class HealthCheckK8SHandler
extends AbstractHttpHandler {
    private static final String LIVENESS_STR = "liveness";
    private static final String READINESS_STR = "readiness";
    private static final String OK = " service is living,one of it`s instances is: ";
    private static final String FAIL = " service is not living, exception:  ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle0(HttpExchange exchange) throws IOException {
        RequestContext rc;
        Map m = ExchangeUtils.parseParameters((HttpExchange)exchange);
        RequestContext oldrc = rc = RequestContext.get();
        try {
            String getserviceid;
            String accountId;
            if (rc == null) {
                rc = RequestContext.create();
            }
            if (rc.getTraceId() == null) {
                rc.setTraceId(TraceIdUtil.createTraceIdString());
            }
            if ((accountId = (String)m.get("accountId")) != null) {
                rc.setAccountId(accountId);
            }
            if ((getserviceid = (String)m.get("getServiceAppId")) != null) {
                getserviceid = ServiceLookup.getServiceAppId((String)getserviceid);
                this.writeHtml("" + getserviceid, exchange);
            } else {
                this.innerHandle(exchange, m);
            }
        }
        finally {
            RequestContext.set((RequestContext)oldrc);
        }
    }

    private void innerHandle(HttpExchange exchange, Map<String, String> m) throws IOException {
        String appid = m.get("appId");
        if (appid != null && appid.length() > 0) {
            try {
                if ("all".equals(appid.trim())) {
                    if (Instance.isAppSplit()) {
                        String strAppIds = System.getProperty("registedAppIds");
                        StringBuilder sbSucess = new StringBuilder();
                        String errorTag = "------ERROR-----";
                        StringBuilder sbError = new StringBuilder(errorTag);
                        if (strAppIds != null) {
                            String[] arrayAppids;
                            for (String id : arrayAppids = strAppIds.split(",")) {
                                try {
                                    sbSucess.append(OK).append(this.getInvokeInstanceInfo(id)).append("<br> ");
                                }
                                catch (Exception e) {
                                    sbError.append(id).append(FAIL).append(e.getMessage()).append("<br> ");
                                }
                            }
                            if (sbError.length() > errorTag.length()) {
                                sbSucess.append((CharSequence)sbError);
                            }
                            this.writeHtml(sbSucess.toString(), exchange);
                        } else {
                            this.writeHtml("No appid was designated from registedAppIds", exchange);
                        }
                    } else {
                        String instanceId = this.getInvokeInstanceInfo("bos");
                        this.writeHtml(OK + instanceId, exchange);
                    }
                } else {
                    String instanceId = this.getInvokeInstanceInfo(appid);
                    this.writeHtml(OK + instanceId, exchange);
                }
            }
            catch (Exception e) {
                this.write502Html(appid + FAIL + "<br>" + e.getMessage(), exchange);
            }
            return;
        }
        String checktype = m.get("checktype");
        boolean canResponse = HealthCheckUtils.canResponse();
        if (Instance.isPausedServiceByMonitor()) {
            if (LIVENESS_STR.equals(checktype)) {
                this.writeHtml("service is Paused by monitor,but pod not need to restart:", exchange);
            } else {
                this.write421Html("ERROR:service is Paused", exchange);
            }
        } else if (!canResponse) {
            this.write421Html("ERROR:service is ", exchange);
        } else {
            this.writeHtml("canResponse:" + String.valueOf(canResponse), exchange);
        }
    }

    private String getInvokeInstanceInfo(String id) {
        long start = System.currentTimeMillis();
        String instanceId = AppCheck.getOneOfInstanceId(id);
        return instanceId + ", cost " + (System.currentTimeMillis() - start) + "ms,request AppId is " + id;
    }

    private void write421Html(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(421, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private void write502Html(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(502, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    protected void writeHtml(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(200, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }
}

