/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.manager;

import java.lang.reflect.Field;
import java.util.concurrent.locks.LockSupport;
import kd.bos.framework.lifecycle.LifecycleManager;
import kd.bos.ha.manager.ServerManager;
import kd.bos.instance.Instance;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.util.JmxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManagerImpl
extends ServerManager {
    private static final String WEB_REQUEST = "kd.metrics:name=kd.metrics.servletfilter.activeRequests,type=counters";
    private static final String DUBBO_REQUEST = "kd.metrics:name=kd.metrics.dubbo.provider.activeRequests,type=counters";
    private static final String FEIGN_REQUEST = "kd.metrics:name=kd.metrics.feign.provider.activeRequests,type=counters";
    private static final String MQ_REQUEST = "kd.metrics:name=kd.metrics.mq.consumer.activeConsumers,type=counters";
    private static final String SCHEDULE_REQUEST = "kd.metrics:name=kd.metrics.schedule.consumer.activeThreads,type=counters";
    private static final String COUNT = "Count";
    private static final String BR = "<br/>";
    private static Logger log = LoggerFactory.getLogger(ServerManagerImpl.class);
    private boolean isStopServer = false;
    private boolean isStopByMonitor = false;

    private boolean getIsStopServer() {
        return this.isStopServer;
    }

    private void setIsStopServer(boolean isStopServer) {
        this.isStopServer = isStopServer;
    }

    @Override
    public String getActiveStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("web request activing: ").append(JmxUtils.getAtt((String)WEB_REQUEST, (String)COUNT)).append(BR);
        if ("feign".equals(MserviceAssemblyConfig.getMserviceRpcType())) {
            sb.append("feign activing: ").append(JmxUtils.getAtt((String)FEIGN_REQUEST, (String)COUNT)).append(BR);
        } else if ("dubbo".equals(MserviceAssemblyConfig.getMserviceRpcType())) {
            sb.append("dubbo activing: ").append(JmxUtils.getAtt((String)DUBBO_REQUEST, (String)COUNT)).append(BR);
        } else {
            sb.append("dubbo activing: ").append(JmxUtils.getAtt((String)DUBBO_REQUEST, (String)COUNT)).append(BR);
            sb.append("feign activing: ").append(JmxUtils.getAtt((String)FEIGN_REQUEST, (String)COUNT)).append(BR);
        }
        sb.append("mq activing: ").append(JmxUtils.getAtt((String)MQ_REQUEST, (String)COUNT)).append(BR);
        sb.append("schedule activing: ").append(JmxUtils.getAtt((String)SCHEDULE_REQUEST, (String)COUNT)).append(BR);
        return sb.toString();
    }

    @Override
    public int getActiveCount() {
        double count = 0.0;
        count += this.getActiveCount(WEB_REQUEST, COUNT);
        count += this.getActiveCount(DUBBO_REQUEST, COUNT);
        count += this.getActiveCount(FEIGN_REQUEST, COUNT);
        count += this.getActiveCount(MQ_REQUEST, COUNT);
        return (int)(count += this.getActiveCount(SCHEDULE_REQUEST, COUNT));
    }

    public void setStopByMonitor(boolean stopByMonitor) {
        this.isStopByMonitor = stopByMonitor;
    }

    @Override
    public boolean isStopByMonitor() {
        return this.isStopByMonitor;
    }

    private double getActiveCount(String objNmae, String attr) {
        try {
            return Double.parseDouble(JmxUtils.getAtt((String)objNmae, (String)attr).toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public void pauseServer() {
        this.pausedServerByMonitor(true);
    }

    @Override
    public void resumeServer() {
        log.info("\u670d\u52a1\u901a\u8fc7Monitor-\u670d\u52a1\u7ba1\u7406-\u6062\u590d\u670d\u52a1\u64cd\u4f5c\u5f00\u59cb\u6062\u590d\u670d\u52a1\u6b63\u5e38.....");
        this.setIsStopServer(false);
        this.pausedServerByMonitor(false);
    }

    @Override
    public void stopServer(int timeoutMillseconds) {
        long currentTimeMillis = System.currentTimeMillis();
        log.info("\u670d\u52a1\u901a\u8fc7Monitor-\u670d\u52a1\u7ba1\u7406-\u91cd\u542f\u64cd\u4f5c\u5f00\u59cb\u91cd\u542f\u670d\u52a1.....");
        try {
            this.pauseServer();
            while (true) {
                if (this.getActiveCount() == 0 || System.currentTimeMillis() - currentTimeMillis > (long)timeoutMillseconds) {
                    LifecycleManager.stop();
                    Thread.sleep(5000L);
                    this.setStopByMonitor(true);
                    System.exit(0);
                    break;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception ex) {
            log.error("pausedServerByMonitor error", (Throwable)ex);
        }
        log.info("\u670d\u52a1\u901a\u8fc7Monitor-\u670d\u52a1\u7ba1\u7406-\u91cd\u542f\u64cd\u4f5c\u5df2\u7ec8\u6b62\u670d\u52a1.");
    }

    @Override
    public void GracefulStopServer(int timeout) {
        long currentTimeMillis = System.currentTimeMillis();
        try {
            this.setIsStopServer(true);
            this.pauseServer();
            LockSupport.parkNanos(6000000000L);
            while (this.getIsStopServer()) {
                if (this.getActiveCount() == 0 || timeout == 0 || timeout > 0 && System.currentTimeMillis() - currentTimeMillis > (long)(timeout * 1000)) {
                    LifecycleManager.stop();
                    this.setStopByMonitor(true);
                    log.info("\u670d\u52a1\u901a\u8fc7Monitor-\u670d\u52a1\u7ba1\u7406-\u4f18\u96c5\u91cd\u542f\u64cd\u4f5c\u5373\u5c06\u91cd\u542f\u670d\u52a1.....");
                    System.exit(0);
                    break;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception ex) {
            log.error("pausedServerByMonitor error", (Throwable)ex);
        }
        log.info("\u901a\u8fc7Monitor-\u670d\u52a1\u7ba1\u7406-\u4f18\u96c5\u91cd\u542f\u64cd\u4f5c,\u670d\u52a1:{}\u5df2\u7ec8\u6b62", (Object)Instance.getInstanceId());
    }

    private void pausedServerByMonitor(boolean paused) {
        try {
            Class<?> c = Class.forName("kd.bos.instance.Instance");
            Field f = c.getDeclaredField("pausedServiceByMonitor");
            f.setAccessible(true);
            f.set(c, paused);
        }
        catch (Exception e) {
            log.error("pausedServerByMonitor error", (Throwable)e);
        }
    }
}

