/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.action;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.ha.watch.action.ActionSpi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class ActionSpiFactory {
    private HashMap<String, ActionSpi> map = new HashMap();
    private static Log logger = LogFactory.getLog(ActionSpiFactory.class);
    private static final String CONFIG_KEY = "ha.watch";
    private static final String CONFIG_KEY_ACTION_SPI_PROVIDER = "ha.watch.actionspi.provider";

    public ActionSpiFactory() {
        this.initSpi();
    }

    private void initSpi() {
        Map<String, String> providers = this.getProviders();
        for (Map.Entry<String, String> provider : providers.entrySet()) {
            try {
                Class<?> clazz = Class.forName(provider.getValue().trim());
                ActionSpi spi = (ActionSpi)clazz.newInstance();
                if (spi == null) continue;
                this.map.put(provider.getKey().trim(), spi);
            }
            catch (Exception ex) {
                logger.error("Error when create action spi instance: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getProviders() {
        String providers = System.getProperty(CONFIG_KEY_ACTION_SPI_PROVIDER, "");
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (StringUtils.isNotEmpty((String)providers)) {
                Map map2 = Splitter.onPattern((String)",").trimResults().withKeyValueSeparator("=").split((CharSequence)providers);
                for (Map.Entry entry : map2.entrySet()) {
                    map.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        catch (Exception ex) {
            logger.error("ha.watch: Error loading action provider from ha.watch.actionspi.provider", (Throwable)ex);
        }
        InputStream resourceAsStream = null;
        try {
            Properties prop = new Properties();
            resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("SpiProvider.properties");
            prop.load(resourceAsStream);
            for (String key : prop.stringPropertyNames()) {
                if (map.containsKey(key)) continue;
                map.put(key, prop.getProperty(key));
            }
        }
        catch (Exception ex) {
            logger.error("ha.watch: Error when load config from SpiProvider.properties: " + ex.getMessage());
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    logger.error("ha.watch: Error when load config from SpiProvider.properties: " + e.getMessage());
                }
            }
        }
        return map;
    }

    public ActionSpi get(String type) {
        if (type.endsWith("Spi")) {
            type = type.replace("Spi", "");
        }
        if (this.map.isEmpty()) {
            this.initSpi();
        }
        return this.map.get(type);
    }
}

