/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.action.spi;

import java.io.IOException;
import java.util.HashMap;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.action.ActionExecResult;
import kd.bos.ha.watch.action.ActionResultEnum;
import kd.bos.ha.watch.action.ActionSpi;
import kd.bos.ha.watch.action.ActionTriggerData;
import kd.bos.ha.watch.action.spi.EmailConfig;
import kd.bos.ha.watch.action.spi.EmailSpiConfig;
import kd.bos.ha.watch.action.spi.SpiUtil;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.util.EmailUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class EmailSpi
implements ActionSpi {
    private static final String CONFIGKEY_Email = "ha.watch.EmailConfig";
    private static EmailConfig emailConfigCache;
    private static Log logger;

    private static void initListener() {
        ConfigurationUtil.observeChange((String)CONFIGKEY_Email, (key, newValue) -> {
            emailConfigCache = EmailSpi.getEmailConfig();
        });
    }

    @Override
    public String getType() {
        return "Email";
    }

    @Override
    public ActionExecResult execute(Action action, ActionTriggerData triggerData, Alarm alarm) {
        return this.execute(action, triggerData, alarm, "");
    }

    public ActionExecResult execute(Action action, ActionTriggerData triggerData, Alarm alarm, String remark) {
        logger.info("Prepare the task execute of email spi, action is : " + action.getName());
        String msg = "";
        EmailConfig emailConfig = this.getSpiConfig();
        EmailSpiConfig spiConfig = null;
        try {
            spiConfig = this.getSpiConfig(action.getName(), action.getConfig());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return ActionExecResult.WithResult(ActionResultEnum.Error, e.getMessage());
        }
        try {
            String content = remark + SpiUtil.getAlarmMsgFromTemplate(triggerData, alarm, this.getType());
            logger.warn("[==HaWatch-EmailSpi executed!==] Action: [" + action.getName() + "], AlarmInfo:" + content);
            String subject = "HaWatch Alarm Message - [" + alarm.getName() + "] Action:" + action.getName();
            EmailUtil.sendMail(spiConfig.getMail(), subject, content, emailConfig);
            logger.info("HaWatch-Send email: " + spiConfig.getMail() + ", alarm is : " + action.getAlarmName());
            return ActionExecResult.WithResult(ActionResultEnum.Success, content);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            msg = "HaWatch-Error exec email spi:" + e.getMessage();
            return ActionExecResult.WithResult(ActionResultEnum.Error, msg);
        }
    }

    private EmailSpiConfig getSpiConfig(String actionName, String configJson) {
        EmailSpiConfig spiConfig = null;
        if (StringUtils.isEmpty((String)configJson)) {
            throw new RuntimeException("HaWatch-EmailSpi-EmailConfig cannot be empty,action is " + actionName);
        }
        try {
            spiConfig = (EmailSpiConfig)JSONUtils.cast((String)configJson, EmailSpiConfig.class, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("HaWatch-EmailSpi-Error reading json from action config, action is " + actionName, e);
        }
        if (spiConfig == null || StringUtils.isEmpty((String)spiConfig.getMail())) {
            throw new RuntimeException("HaWatch-EmailSpi,Error reading from action config - email cannot be empty, action is " + actionName);
        }
        return spiConfig;
    }

    private EmailConfig getSpiConfig() {
        EmailConfig emailConfig;
        if (emailConfigCache != null) {
            return emailConfigCache;
        }
        emailConfigCache = emailConfig = EmailSpi.getEmailConfig();
        return emailConfig;
    }

    private static EmailConfig getEmailConfig() {
        HashMap<String, String> map = null;
        String providers = System.getProperty(CONFIGKEY_Email, "");
        if (StringUtils.isNotEmpty((String)providers)) {
            String[] splitArr;
            map = new HashMap<String, String>(8);
            for (String str : splitArr = providers.split(",")) {
                str = str.trim();
                int firstIndex = str.indexOf("=");
                map.put(str.substring(0, firstIndex).trim(), str.substring(firstIndex + 1, str.length()).trim());
            }
        }
        EmailConfig emailConfig = new EmailConfig();
        if (map != null) {
            emailConfig.setMailHost((String)map.get("MailHost"));
            emailConfig.setUseSSL(Boolean.parseBoolean((String)map.get("UseSSL")));
            emailConfig.setPort(Integer.parseInt((String)map.get("Port")));
            String timeout = (String)map.get("Timeout");
            if (StringUtils.isNotEmpty((String)timeout)) {
                emailConfig.setTimeout(Integer.parseInt(timeout));
            }
            emailConfig.setSender((String)map.get("Sender"));
            emailConfig.setUserName((String)map.get("UserName"));
            String encryptStr = (String)map.get("Password");
            String password = EncrypterFactory.getEncrypter().decode(encryptStr);
            emailConfig.setPassword(password);
        }
        if (StringUtils.isEmpty((String)emailConfig.getMailHost()) || emailConfig.getPort() == 0 || StringUtils.isEmpty((String)emailConfig.getSender()) || StringUtils.isEmpty((String)emailConfig.getUserName()) || StringUtils.isEmpty((String)emailConfig.getPassword())) {
            throw new RuntimeException("HaWatch-EmailSpi-Error reading from action config, MailHost/Sender/UserName/Password/Port/UseSSL cannot be empty");
        }
        return emailConfig;
    }

    static {
        logger = LogFactory.getLog(EmailSpi.class);
        EmailSpi.initListener();
    }
}

