/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.action.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.action.ActionExecResult;
import kd.bos.ha.watch.action.ActionResultEnum;
import kd.bos.ha.watch.action.ActionSpi;
import kd.bos.ha.watch.action.ActionTriggerData;
import kd.bos.ha.watch.action.spi.SmsApiConfig;
import kd.bos.ha.watch.action.spi.SmsSenderSpi;
import kd.bos.ha.watch.action.spi.SmsSpiConfig;
import kd.bos.ha.watch.action.spi.SpiUtil;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.util.SmsUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class SmsSpi
implements ActionSpi {
    public static final String KD_SMS_CLIENT_PWD = "kd.sms.clientPwd";
    private static final String CONFIGKEY_SMSAPI = "ha.watch.SmsConfig";
    public static final String KD_SMS_API_URL = "kd.sms.apiUrl";
    public static final String KD_SMS_CLIENT_ID = "kd.sms.clientID";
    public static final String[] CHECK_KEYS = new String[]{"kd.sms.apiUrl", "kd.sms.clientID", "kd.sms.clientPwd"};
    private static Log logger = LogFactory.getLog(SmsSpi.class);
    private static SmsApiConfig smsApiConfigCache;
    private static final String EXT_SMS_SENDER = "ha.watch.SmsSenderSpi.ext";

    @Override
    public String getType() {
        return "Sms";
    }

    @Override
    public ActionExecResult execute(Action action, ActionTriggerData triggerData, Alarm alarm) {
        return this.execute(action, triggerData, alarm, "");
    }

    public ActionExecResult execute(Action action, ActionTriggerData triggerData, Alarm alarm, String smsRemark) {
        logger.info("Prepare the task execute of sms spi, action is : " + action.getName());
        String msg = "";
        SmsSpiConfig spiConfig = null;
        try {
            spiConfig = this.getSmsConfig(action.getName(), action.getConfig());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return ActionExecResult.WithResult(ActionResultEnum.Error, e.getMessage());
        }
        try {
            SmsApiConfig smsApiConfig = this.getSmsApiConfig();
            String content = smsRemark + SpiUtil.getAlarmMsgFromTemplate(triggerData, alarm, this.getType());
            logger.warn("[==HaWatch-SmsSpi executed!==] Action: [" + action.getName() + "], AlarmInfo:" + content);
            SmsSenderSpi smsSenderSpi = this.getSmsSenderSip();
            if (smsSenderSpi == null) {
                SmsUtil.sendSmsMessage(spiConfig.getPhone(), content, alarm.getState(), smsApiConfig);
            } else {
                smsSenderSpi.sendMessage(content, spiConfig.getPhone());
            }
            logger.info("HaWatch-send sms, alarm is : " + action.getAlarmName());
            return ActionExecResult.WithResult(ActionResultEnum.Success, content);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            msg = "HaWatch-Error exec sms spi:" + e.getMessage();
            return ActionExecResult.WithResult(ActionResultEnum.Error, msg);
        }
    }

    private SmsSpiConfig getSmsConfig(String actionName, String configJson) {
        SmsSpiConfig apiConfig = null;
        if (StringUtils.isEmpty((String)configJson)) {
            throw new RuntimeException("HaWatch-SmsSpi-config cannot be empty,action is " + actionName);
        }
        try {
            apiConfig = (SmsSpiConfig)JSONUtils.cast((String)configJson, SmsSpiConfig.class, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("HaWatch-SmsSpi-Error reading json from action config, action is " + actionName, e);
        }
        if (StringUtils.isEmpty((String)apiConfig.getPhone())) {
            throw new RuntimeException("HaWatch-SmsSpi-Error reading from action config - phone name cannot be empty, action is " + actionName);
        }
        return apiConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmsApiConfig getSmsApiConfig() {
        if (smsApiConfigCache != null) {
            return smsApiConfigCache;
        }
        HashMap<String, String> map = new HashMap<String, String>(8);
        InputStream inputStream = null;
        try {
            Properties prop = new Properties();
            inputStream = this.getClass().getClassLoader().getResourceAsStream("SmsApiConfig.properties");
            prop.load(inputStream);
            for (String string : prop.stringPropertyNames()) {
                map.put(string, prop.getProperty(string));
            }
        }
        catch (Exception ex) {
            logger.error("HaWatch-Error when load config from SmsApiConfig.properties: " + ex.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("HaWatch-Error when load config from SmsApiConfig.properties: " + e.getMessage());
                }
            }
        }
        String providers = System.getProperty(CONFIGKEY_SMSAPI, "");
        if (StringUtils.isNotEmpty((String)providers)) {
            String[] splitArr;
            String[] stringArray = splitArr = providers.split(",");
            int n = stringArray.length;
            for (int e = 0; e < n; ++e) {
                String str = stringArray[e];
                str = str.trim();
                int firstIndex = str.indexOf("=");
                map.put(str.substring(0, firstIndex).trim(), str.substring(firstIndex + 1).trim());
            }
        }
        if (!map.isEmpty()) {
            for (String key : CHECK_KEYS) {
                if (!StringUtils.isEmpty((String)((String)map.get(key)))) continue;
                throw new RuntimeException("the SmsApiConfig of " + key + " can not be null!");
            }
            SmsApiConfig smsApiConfig = new SmsApiConfig();
            smsApiConfig.setApiUrl((String)map.get(KD_SMS_API_URL));
            smsApiConfig.setClientID((String)map.get(KD_SMS_CLIENT_ID));
            smsApiConfig.setSmsCode((String)map.get("kd.sms.smsCode"));
            smsApiConfig.setSmsCodeAlarm((String)map.get("kd.sms.smsCodeAlarm"));
            smsApiConfig.setSmsCodeOK((String)map.get("kd.sms.smsCodeOK"));
            smsApiConfig.setCountryCode((String)map.get("kd.sms.countryCode"));
            smsApiConfig.setSignature((String)map.get("kd.sms.signature"));
            try {
                smsApiConfig.setConnectTimeout(Integer.parseInt((String)map.get("kd.sms.connectTimeout")));
                smsApiConfig.setSocketTimeout(Integer.parseInt((String)map.get("kd.sms.socketTimeout")));
            }
            catch (Exception exception) {
                logger.error("HaWatch-Error when load config from SmsApiConfig.properties(timeout): " + exception.getMessage());
            }
            String string = (String)map.get(KD_SMS_CLIENT_PWD);
            String secret = EncrypterFactory.getEncrypter().decode(string);
            smsApiConfig.setClientSecret(secret);
            smsApiConfigCache = smsApiConfig;
            return smsApiConfig;
        }
        return null;
    }

    private SmsSenderSpi getSmsSenderSip() {
        String className = System.getProperty(EXT_SMS_SENDER);
        if (!StringUtils.isEmpty((String)className)) {
            try {
                return (SmsSenderSpi)Class.forName(className).newInstance();
            }
            catch (Exception t) {
                String msg = "init class " + className + " error:";
                logger.error(msg, (Throwable)t);
                throw new RuntimeException(msg, t);
            }
        }
        return null;
    }
}

