/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.action.spi;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.ha.watch.action.ActionTriggerData;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.alarm.AlarmState;
import kd.bos.ha.watch.alarm.Unit;
import kd.bos.ha.watch.util.CommonUtil;
import kd.bos.ha.watch.util.SmsUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class SpiUtil {
    private static Log logger = LogFactory.getLog(SpiUtil.class);
    public static final String BOS_HA = "bos-ha";
    private static final String CLUSTER_NAME = "{clusterName}";
    private static final String APP_NAME = "{appName}";
    private static final String CLIENT_IP = "{clientIp}";
    private static final String STATE = "{state}";
    private static final String ALARM_NAME = "{alarmName}";
    private static final String METRIC_NAME = "{metricName}";
    private static final String STATISTIC = "{statistic}";
    private static final String VALUE = "{value}";
    private static final String TIMESTAMP = "{timestamp}";
    private static final String HA_WATCH_TEMPLATE = "ha.watch.template";
    private static final String DEFAULT_KEY = "Default";
    private static Map<String, String> TEMPLATE_MAP;

    private static void initTemplateMap() {
        try {
            TEMPLATE_MAP = new HashMap<String, String>(2);
            String templateJson = System.getProperty(HA_WATCH_TEMPLATE);
            if (StringUtils.isEmpty((String)templateJson)) {
                try (InputStream inputStream = SmsUtil.class.getClassLoader().getResourceAsStream("AlarmMsgTemplate.json");
                     InputStreamReader isr = new InputStreamReader(inputStream);
                     BufferedReader br = new BufferedReader(isr);){
                    templateJson = ((Stream)br.lines().parallel()).collect(Collectors.joining(System.lineSeparator()));
                }
            }
            if (StringUtils.isNotEmpty((String)templateJson)) {
                TEMPLATE_MAP = (Map)JSONUtils.cast((String)templateJson, Map.class);
            }
        }
        catch (Exception e) {
            logger.error("initTemplateMap error!", (Throwable)e);
        }
    }

    public static String GetAlarmMsgDesc(ActionTriggerData triggerData, Alarm alarm, boolean isDescIncludeAlarmState, boolean isCrlf) {
        String alarmStateDesc = "";
        if (isDescIncludeAlarmState) {
            if (triggerData.getOldState() == AlarmState.ALARM && triggerData.getNewState() == AlarmState.OK) {
                alarmStateDesc = Resources.getString((String)"\u5df2\u6062\u590d\u6b63\u5e38\u3002", (String)"SpiUtil_0", (String)BOS_HA, (Object[])new Object[0]);
            }
            if (triggerData.getNewState() == AlarmState.ALARM) {
                alarmStateDesc = Resources.getString((String)"\u53d1\u751f\u544a\u8b66[HA]\u3002", (String)"SpiUtil_1", (String)BOS_HA, (Object[])new Object[0]);
            }
            if (StringUtils.isEmpty((String)alarmStateDesc)) {
                alarmStateDesc = Resources.getString((String)"\u5f53\u524d\u72b6\u6001:", (String)"SpiUtil_2", (String)BOS_HA, (Object[])new Object[0]) + (Object)((Object)triggerData.getNewState()) + "\u3002";
            }
        }
        String crlf = isCrlf ? System.getProperty("line.separator") : "";
        String triggerDataDesc = SpiUtil.getValuesWithHumanDesc(triggerData.getValues(), alarm.getUnit());
        String dimesionData = triggerData.getDimensionMap() == null ? "" : triggerData.getDimensionMap().toString();
        String timestamp = new SimpleDateFormat("MM-dd HH:mm").format(triggerData.getTimestamp());
        String content = "[" + alarm.getName() + "] " + alarmStateDesc + crlf + Resources.getString((String)"\u5206\u7c7b: ", (String)"SpiUtil_3", (String)BOS_HA, (Object[])new Object[0]) + alarm.getCategory() + "\uff0c" + crlf + Resources.getString((String)"\u6307\u6807: ", (String)"SpiUtil_4", (String)BOS_HA, (Object[])new Object[0]) + alarm.getMetricName() + "\u3002" + crlf + Resources.getString((String)"\u7ef4\u5ea6: ", (String)"SpiUtil_5", (String)BOS_HA, (Object[])new Object[0]) + dimesionData + "\uff0c" + crlf + Resources.getString((String)String.format("\u6570\u636e: [%s]", triggerDataDesc), (String)"SpiUtil_6", (String)BOS_HA, (Object[])new Object[0]) + "\uff0c" + crlf + Resources.getString((String)"\u9608\u503c: ", (String)"SpiUtil_7", (String)BOS_HA, (Object[])new Object[0]) + alarm.getStatistic().getDesc() + alarm.getComparisonOperator().getDesc() + alarm.getThreshold() + alarm.getUnit().getDesc() + "\uff0c" + crlf + Resources.getString((String)"\u65f6\u95f4: ", (String)"SpiUtil_8", (String)BOS_HA, (Object[])new Object[0]) + timestamp;
        return content;
    }

    public static String getAlarmMsgFromTemplate(ActionTriggerData triggerData, Alarm alarm, String actionSpiType) {
        try {
            String alarmMsgTemplate = SpiUtil.getAlarmMsgTemplate(actionSpiType);
            if (StringUtils.isEmpty((String)alarmMsgTemplate)) {
                return SpiUtil.GetAlarmMsgDesc(triggerData, alarm, true, true);
            }
            Map<String, String> alarmMsgMap = SpiUtil.getAlarmMsgMap(triggerData, alarm);
            for (Map.Entry<String, String> entry : alarmMsgMap.entrySet()) {
                String key = entry.getKey();
                if (!alarmMsgTemplate.contains(key)) continue;
                alarmMsgTemplate = alarmMsgTemplate.replace(key, alarmMsgMap.get(key));
            }
            return alarmMsgTemplate;
        }
        catch (Exception e) {
            logger.error("getAlarmMsgFromTemplate error!", (Throwable)e);
            return SpiUtil.GetAlarmMsgDesc(triggerData, alarm, true, true);
        }
    }

    private static Map<String, String> getAlarmMsgMap(ActionTriggerData triggerData, Alarm alarm) {
        HashMap<String, String> alarmMsgMap = new HashMap<String, String>();
        Map<String, String> dimensionMap = triggerData.getDimensionMap();
        alarmMsgMap.put(CLUSTER_NAME, "");
        alarmMsgMap.put(APP_NAME, "");
        alarmMsgMap.put(CLIENT_IP, "");
        if (dimensionMap != null) {
            alarmMsgMap.put(CLUSTER_NAME, dimensionMap.get("clusterName"));
            alarmMsgMap.put(APP_NAME, dimensionMap.get("appName"));
            alarmMsgMap.put(CLIENT_IP, dimensionMap.get("clientIp"));
        }
        String alarmName = alarm.getName();
        alarmMsgMap.put(ALARM_NAME, alarmName);
        if (triggerData.getOldState() == AlarmState.ALARM && triggerData.getNewState() == AlarmState.OK) {
            alarmMsgMap.put(STATE, String.format("Alarm [%s] recovered", alarmName));
        } else if (triggerData.getNewState() == AlarmState.ALARM) {
            alarmMsgMap.put(STATE, String.format("[%s] Alarm occurred", alarmName));
        } else {
            alarmMsgMap.put(STATE, alarmName + triggerData.getNewState().toString());
        }
        alarmMsgMap.put(METRIC_NAME, alarm.getMetricName());
        alarmMsgMap.put(STATISTIC, alarm.getStatistic().getDesc() + alarm.getComparisonOperator().getDesc() + alarm.getThreshold() + alarm.getUnit().getDesc());
        alarmMsgMap.put(VALUE, SpiUtil.getValuesWithHumanDesc(triggerData.getValues(), alarm.getUnit()));
        alarmMsgMap.put(TIMESTAMP, new SimpleDateFormat("MM-dd HH:mm").format(triggerData.getTimestamp()));
        return alarmMsgMap;
    }

    private static String getAlarmMsgTemplate(String actionSpiType) {
        if (TEMPLATE_MAP == null) {
            SpiUtil.initTemplateMap();
        }
        return TEMPLATE_MAP.getOrDefault(actionSpiType, TEMPLATE_MAP.get(DEFAULT_KEY));
    }

    public static String GetAlarmMsgDesc(ActionTriggerData triggerData, Alarm alarm) {
        return SpiUtil.GetAlarmMsgDesc(triggerData, alarm, true, false);
    }

    public static String getValuesWithHumanDesc(Number[] values, Unit unit) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(CommonUtil.getSizeWithHumanDesc((Double)values[i], unit));
            if (i == values.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    static {
        ConfigurationUtil.observeChange((String)HA_WATCH_TEMPLATE, (key, newValue) -> SpiUtil.initTemplateMap());
    }
}

