/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.action.spi;

import java.io.File;
import java.io.IOException;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.action.ActionExecResult;
import kd.bos.ha.watch.action.ActionResultEnum;
import kd.bos.ha.watch.action.ActionSpi;
import kd.bos.ha.watch.action.ActionTriggerData;
import kd.bos.ha.watch.action.spi.ShellSpiConfig;
import kd.bos.ha.watch.action.spi.SpiUtil;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.util.SmsUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WXShellSpi
implements ActionSpi {
    private static Logger logger = LoggerFactory.getLogger(WXShellSpi.class);

    @Override
    public String getType() {
        return "WXShell";
    }

    @Override
    public ActionExecResult execute(Action action, ActionTriggerData triggerData, Alarm alarm) {
        logger.info("Prepare the task execute of wxMsg shell spi, action is : " + action.getName());
        String msg = "";
        ShellSpiConfig wxspiConfig = null;
        try {
            wxspiConfig = this.getShellConfig(action.getName(), action.getConfig());
        }
        catch (Exception e) {
            logger.error("WXShell:" + e.getMessage());
            return ActionExecResult.WithResult(ActionResultEnum.Error, e.getMessage());
        }
        try {
            String msgContent = "HaWatch" + System.getProperty("line.separator") + SpiUtil.GetAlarmMsgDesc(triggerData, alarm, true, true);
            logger.warn("[==HaWatch-WXShellSpi executed!==] Action: [" + action.getName() + "], AlarmInfo:" + msgContent);
            String execResult = SmsUtil.execShell(wxspiConfig.getShellCmd(), msgContent);
            if (execResult.length() > 500) {
                execResult = execResult.substring(0, 500);
            }
            logger.info("exec wxmsg shell: " + wxspiConfig.getShellCmd() + ", alarm is : " + action.getAlarmName());
            return ActionExecResult.WithResult(ActionResultEnum.Success, execResult + " | " + msgContent);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            msg = "Error exec wxmsg spi:" + e.getMessage();
            return ActionExecResult.WithResult(ActionResultEnum.Error, msg);
        }
    }

    private ShellSpiConfig getShellConfig(String actionName, String configJson) {
        ShellSpiConfig apiConfig = null;
        if (StringUtils.isEmpty((String)configJson)) {
            throw new RuntimeException(Resources.getString((String)"WXShellSpi-\u914d\u7f6e\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a,action is ", (String)"WXShellSpi_0", (String)"bos-ha", (Object[])new Object[0]) + actionName);
        }
        try {
            apiConfig = (ShellSpiConfig)JSONUtils.cast((String)configJson, ShellSpiConfig.class, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("WXShellSpi-Error reading json from action config, action is " + actionName, e);
        }
        String shellCmd = apiConfig.getShellCmd();
        if (StringUtils.isEmpty((String)shellCmd)) {
            throw new RuntimeException("WXShellSpi-Error reading from action config -ShellCmd cannot be empty, action is " + actionName);
        }
        File file = new File(shellCmd);
        if (!file.exists()) {
            throw new RuntimeException("WXShellSpi not exists:" + shellCmd);
        }
        return apiConfig;
    }
}

