/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.alarm;

import kd.bos.ha.watch.alarm.Unit;
import kd.bos.ha.watch.util.CommonUtil;

public enum ComparisonOperator {
    GT(">"),
    GE(">="),
    LT("<"),
    LE("<=");

    private String _desc;

    private ComparisonOperator(String desc) {
        this._desc = desc;
    }

    public String getDesc() {
        return this._desc;
    }

    public static boolean eval(ComparisonOperator comparisonOperator, double value, double threshold, Unit thresUnit) {
        double threshold2 = 0.0;
        threshold2 = CommonUtil.getNumberFromHumanSize((long)threshold, thresUnit);
        switch (comparisonOperator) {
            case GT: {
                return value > threshold2;
            }
            case GE: {
                return value >= threshold2;
            }
            case LT: {
                return value < threshold2;
            }
            case LE: {
                return value <= threshold2;
            }
        }
        throw new RuntimeException("ComparisonOperator is impossible");
    }
}

