/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import kd.bos.algo.AlgoConfig;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.AlgoEnv;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algo.dataset.cache.CachedDataSetImpl;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.DataSetCacheSpiFactory;
import kd.bos.algo.env.AlgoContextImpl;
import kd.bos.algo.env.Environment;
import kd.bos.algo.env.ThreadContext;
import kd.bos.algo.env.jvm.JvmEnvironment;
import kd.bos.algo.util.AlgoSystemInit;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class Algo {
    public abstract DataSet createDataSet(Collection<Object[]> var1, RowMeta var2);

    public abstract DataSet createDataSet(Iterator<Object[]> var1, RowMeta var2);

    public abstract DataSet createDataSet(Iterable<Object[]> var1, RowMeta var2);

    public abstract DataSet createDataSet(ResultSet var1);

    public abstract DataSet createDataSet(ResultSet var1, RowMeta var2);

    public abstract DataSet createDataSet(Input ... var1);

    public abstract DataSetBuilder createDataSetBuilder(RowMeta var1);

    @SdkInternal
    public abstract void execute();

    public static AlgoContext newContext() {
        return new AlgoContextImpl();
    }

    public static void closeAllDataSet() {
        ThreadContext.clear();
    }

    public static Algo create(String algoKey) {
        Environment env;
        ThreadContext ctx = ThreadContext.getCurrent();
        if (ctx != null && (env = ctx.getEnv(algoKey)) != null) {
            return env;
        }
        AlgoConfig config = new AlgoConfig(algoKey);
        return Algo.create(config);
    }

    @SdkInternal
    public static Algo create(AlgoConfig config) {
        AlgoEnv env = config.getEnv(AlgoEnv.JVM);
        switch (env) {
            case JVM: {
                JvmEnvironment environment = new JvmEnvironment(config);
                return environment;
            }
        }
        return null;
    }

    public CachedDataSet.Builder createCachedDataSetBuilder(RowMeta rowMeta, CacheHint hint) {
        return new CachedDataSetBuilder(rowMeta, hint, null);
    }

    public static CachedDataSet getCacheDataSet(String cacheId) {
        return new CachedDataSetImpl(cacheId);
    }

    public static void removeCacheDataSet(String cacheId) {
        DataSetCacheSpi spi = DataSetCacheSpiFactory.getSpi();
        try {
            spi.delete(cacheId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        AlgoSystemInit.init();
    }
}

