/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo;

import java.io.Serializable;
import java.util.Objects;
import kd.bos.algo.DataType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class Field
implements Serializable {
    private static final long serialVersionUID = -2442422083866675398L;
    String name;
    String alias;
    private DataType dataType;
    private boolean nullable;

    public Field(String name, DataType dataType) {
        this(name, dataType, false);
    }

    public Field(String name, DataType dataType, boolean nullable) {
        this(name, name, dataType, nullable);
    }

    public Field(String name, String alias, DataType dataType, boolean nullable) {
        this.name = name;
        this.alias = alias == null ? name : alias;
        this.dataType = dataType;
        this.nullable = nullable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias == null ? this.name : this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Field copy() {
        return new Field(this.name, this.alias, this.dataType, this.nullable);
    }

    public Field deriveAlias(String alias) {
        return new Field(this.name, alias, this.dataType, this.nullable);
    }

    public Field deriveName(String name) {
        return new Field(name, name, this.dataType, this.nullable);
    }

    public Field derive(String name, String alias) {
        return new Field(name, alias, this.dataType, this.nullable);
    }

    public boolean equals(Object x) {
        if (x == null || !(x instanceof Field)) {
            return false;
        }
        Field field2 = (Field)x;
        return Objects.equals(this.getAlias(), field2.getAlias()) && Objects.equals(this.getDataType(), field2.getDataType());
    }

    public String toString() {
        String r = this.name;
        if (this.alias != null && !this.alias.equals(this.name)) {
            r = r + " as " + this.alias;
        }
        return r;
    }
}

