/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.util.StringIntMap;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class RowMeta
implements Serializable {
    private static final long serialVersionUID = -3482884151225986183L;
    private final Field[] fields;
    private final StringIntMap aliasIndexes;
    private int[] dataTypeOrdinals;
    private final boolean[] nullables;

    public RowMeta(String[] fieldNames, DataType[] dataTypes) {
        this(RowMeta.createFields(fieldNames, dataTypes));
    }

    private static Field[] createFields(String[] fieldNames, DataType[] dataTypes) {
        Preconditions.checkArgument((fieldNames.length == dataTypes.length ? 1 : 0) != 0, (String)"fieldNames length must equals to dataTypes, but %d <> %d.", (int)fieldNames.length, (int)dataTypes.length);
        Field[] fields = new Field[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fields[i] = new Field(fieldNames[i], dataTypes[i]);
        }
        return fields;
    }

    public RowMeta(Field ... fields) {
        int i;
        this.fields = fields;
        this.aliasIndexes = new StringIntMap(fields.length);
        this.nullables = new boolean[fields.length];
        for (i = 0; i < fields.length; ++i) {
            this.aliasIndexes.put(fields[i].name.toLowerCase(), i);
            this.nullables[i] = fields[i].isNullable();
        }
        for (i = 0; i < fields.length; ++i) {
            if (fields[i].alias == null) continue;
            this.aliasIndexes.put(fields[i].alias.toLowerCase(), i);
        }
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Field getField(int index) {
        return this.fields[index];
    }

    public Field getField(String nameOrAlias) {
        return this.getField(nameOrAlias, true);
    }

    public Field getField(String nameOrAlias, boolean throwException) {
        int index = this.getFieldIndex(nameOrAlias, throwException);
        if (index > -1) {
            return this.fields[index];
        }
        return null;
    }

    public int getFieldIndex(String nameOrAlias) {
        Preconditions.checkNotNull((Object)nameOrAlias, (Object)"Argument field name is null");
        return this.getFieldIndex(nameOrAlias, true);
    }

    public int getFieldIndex(String nameOrAlias, boolean throwException) {
        int index = this.aliasIndexes.get(nameOrAlias);
        if (index == -1) {
            index = this.aliasIndexes.get(nameOrAlias.toLowerCase(Locale.ENGLISH));
            if (index != -1) {
                this.aliasIndexes.put(nameOrAlias, index);
                return index;
            }
        } else {
            return index;
        }
        if (throwException) {
            throw AlgoException.create("field %s not found.", nameOrAlias);
        }
        return -1;
    }

    public String getFieldName(int index) {
        return this.fields[index].getName();
    }

    public String getFieldAlias(int index) {
        return this.fields[index].getAlias();
    }

    public DataType getFieldDataType(int index) {
        return this.fields[index].getDataType();
    }

    public final boolean isNullable(int index) {
        return this.nullables[index];
    }

    public Map<String, Object> toMap(Row row) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.toMap(row, map);
        return map;
    }

    public void toMap(Row row, Map<String, Object> map) {
        for (int i = 0; i < this.fields.length; ++i) {
            Object value = row.get(i);
            value = DataType.convertValue(this.fields[i].getDataType(), value);
            map.put(this.fields[i].getAlias(), value);
        }
    }

    public Field[] getFields(String[] fieldNames) {
        Field[] newFields = new Field[fieldNames.length];
        for (int i = 0; i < newFields.length; ++i) {
            Field field = this.getField(fieldNames[i]);
            if (field == null) continue;
            newFields[i] = field.copy();
        }
        return newFields;
    }

    public static RowMeta fromResultSet(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            Field[] fields = new Field[rsmd.getColumnCount()];
            for (int i = 0; i < fields.length; ++i) {
                int sqlType = rsmd.getColumnType(i + 1);
                String name = rsmd.getColumnLabel(i + 1);
                fields[i] = new Field(name, DataType.fromSqlType(sqlType), true);
            }
            return new RowMeta(fields);
        }
        catch (SQLException e) {
            throw new AlgoException(e);
        }
    }

    public String toString() {
        return String.format("RowMeta%s", Arrays.toString(this.fields));
    }

    public List<DataType> getTypes() {
        return (List)Arrays.asList(this.fields).stream().map(Field::getDataType).collect(ImmutableList.toImmutableList());
    }

    public String[] getFieldNames() {
        String[] names = new String[this.fields.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.fields[i].getAlias();
        }
        return names;
    }

    public DataType[] getDataTypes() {
        DataType[] types = new DataType[this.fields.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.fields[i].getDataType();
        }
        return types;
    }

    public int[] getDataTypeOrdinals() {
        if (this.dataTypeOrdinals == null) {
            int[] ret = new int[this.fields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                ret[i] = this.fields[i].getDataType().ordinal;
            }
            this.dataTypeOrdinals = ret;
        }
        return this.dataTypeOrdinals;
    }

    public DataType getDataType(int index) {
        return this.fields[index].getDataType();
    }
}

