/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.schema.DataSetTable;
import kd.bos.algo.dataset.schema.RegisterSchema;
import kd.bos.algo.sql.parser.SqlParser;
import kd.bos.algo.sql.resolve.ColumnAliasTransformer;
import kd.bos.algo.sql.resolve.InputTypeChecker;
import kd.bos.algo.sql.resolve.RuleTraverResolver;
import kd.bos.algo.sql.resolve.SchemaTraverResolver;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;

public class ExprParser {
    private SqlParser parser = new SqlParser();
    private SchemaTraverResolver schemaResolver;

    public ExprParser(RowMeta rowMeta) {
        RegisterSchema schema = new RegisterSchema();
        schema.registerRelation(new DataSetTable(schema, rowMeta, "default"));
        this.schemaResolver = new SchemaTraverResolver(schema, null);
    }

    public ExprParser(RowMeta rowMeta, Map<String, Object> params) {
        RegisterSchema schema = new RegisterSchema();
        schema.registerRelation(new DataSetTable(schema, rowMeta, "default"));
        this.schemaResolver = new SchemaTraverResolver(schema, params);
    }

    public ExprParser(RowMeta leftRowMeta, RowMeta rightRowMeta, boolean rightFirst) {
        RegisterSchema leftSchema = new RegisterSchema();
        leftSchema.registerRelation(new DataSetTable(leftSchema, leftRowMeta, "left"));
        RegisterSchema rightSchema = new RegisterSchema();
        rightSchema.registerRelation(new DataSetTable(rightSchema, rightRowMeta, "right"));
        this.schemaResolver = rightFirst ? new SchemaTraverResolver(rightSchema, leftSchema, false) : new SchemaTraverResolver(leftSchema, rightSchema, false);
    }

    public Expr parseWithoutResolve(String expr) {
        return this.parser.parseExpr(expr);
    }

    public Expr[] parseWithoutResolve(String[] exprs) {
        Expr[] result = new Expr[exprs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.parseWithoutResolve(exprs[i]);
        }
        return result;
    }

    public Expr parse(String expr) {
        try {
            Expr ex = this.parser.parseExpr(expr);
            return this.resolve(ex);
        }
        catch (AlgoException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AlgoException("parse expr error: " + expr, e);
        }
    }

    public Expr[] parse(String[] exprs) {
        Expr[] result = new Expr[exprs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.parse(exprs[i]);
        }
        return result;
    }

    public Expr resolve(Expr ex) {
        ex = ex.resolve(this.schemaResolver, RuleTraverResolver.instance, InputTypeChecker.instance);
        return ex;
    }

    public Expr[] resolve(Expr[] exprs) {
        Expr[] result = new Expr[exprs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.resolve(exprs[i]);
        }
        return result;
    }

    public Alias transformAlias(Expr expr) {
        return (Alias)expr.resolve(ColumnAliasTransformer.instance);
    }

    public Alias[] transformAlias(Expr[] exprs) {
        Alias[] result = new Alias[exprs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.transformAlias(exprs[i]);
        }
        return result;
    }
}

