/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.EmptyInnerRowIterator;
import kd.bos.algo.dataset.InnerRowIteratorWrapper;
import kd.bos.algo.dataset.InnerRowIteratorWrapper2;

public abstract class InnerRowIterator
implements Iterator<Row> {
    public static final InnerRowIterator EMPTY = new EmptyInnerRowIterator();
    private Boolean hasNexted = null;
    private boolean hasItered = false;
    private Boolean isEmpty = null;
    protected AutoCloseable closer;
    protected boolean autoClose = true;

    public static InnerRowIterator wrapper(Iterator<Row> iter) {
        if (iter instanceof InnerRowIterator) {
            return (InnerRowIterator)iter;
        }
        return new InnerRowIteratorWrapper(iter);
    }

    public static InnerRowIterator wrapperObjectArray(RowMeta rowMeta, Iterator<Object[]> iter) {
        return new InnerRowIteratorWrapper2(rowMeta, iter);
    }

    protected abstract boolean _hasNext();

    protected abstract Row _next();

    @Override
    public boolean hasNext() {
        return this.hasNext(true);
    }

    private boolean hasNext(boolean close) {
        if (this.hasNexted != null) {
            return this.hasNexted;
        }
        boolean b = this._hasNext();
        this.hasNexted = b;
        if (this.isEmpty == null) {
            this.isEmpty = !b;
        }
        if (!b && this.closer != null && this.autoClose && close) {
            this.autoClose();
        }
        return b;
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Row next = this._next();
        this.hasNexted = null;
        this.hasItered = true;
        return next;
    }

    public boolean hasItered() {
        return this.hasItered;
    }

    public boolean isEmpty() {
        return this.isEmpty == null ? !this.hasNext(false) : this.isEmpty;
    }

    public void setCloser(AutoCloseable closer) {
        this.closer = closer;
    }

    public void setAutoClose(boolean b) {
        this.autoClose = b;
    }

    public final void autoClose() {
        try {
            this.closer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void close() {
    }
}

