/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.ConstantCalc;

public class NewFieldsRow
extends AbstractRow {
    private RowMeta rowMeta;
    private Row innerRow;
    private Calc[] calcs;
    private int innerIndex;

    public NewFieldsRow(RowMeta rowMeta, Row innerRow, int innerIndex, Calc[] calcs) {
        this.rowMeta = rowMeta;
        this.innerRow = innerRow;
        this.calcs = calcs;
        this.innerIndex = innerIndex;
    }

    @Override
    public int size() {
        return this.rowMeta.getFieldCount();
    }

    @Override
    public Object get(int index) {
        if (index > this.innerIndex) {
            return this.getNewValue(index - this.innerIndex - 1);
        }
        return this.innerRow.get(index);
    }

    private Object getNewValue(int index) {
        Calc calc = this.calcs[index];
        if (calc instanceof ConstantCalc) {
            return ((ConstantCalc)calc).getValue();
        }
        return calc.execute(this.innerRow, null);
    }

    @Override
    public Object[] values() {
        return this.defaultConvertValues();
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

