/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.addfield;

import java.util.Iterator;
import java.util.function.Supplier;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.NewFieldRow;
import kd.bos.algo.dataset.NewFieldValueRow;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;
import kd.bos.algo.sql.tree.calc.ConstantCalc;

public class AddFieldDataSet
extends AbstractDataSet {
    private String expr;
    private String alias;
    private Field newField;
    private Calc calc;

    public AddFieldDataSet(AbstractDataSet inner, String expr, String alias) {
        this("AddField", inner, expr, alias);
    }

    public AddFieldDataSet(String dataSetName, AbstractDataSet inner, String expr, String alias) {
        super(dataSetName, inner);
        this.expr = expr;
        this.alias = alias;
        this.init();
    }

    private void init() {
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        ExprParser parser = new ExprParser(rowMeta);
        Expr newExpr = parser.parse(this.expr);
        this.calc = CalcCompiler.compile(rowMeta, newExpr);
        DataType dataType = newExpr.getDataType();
        this.newField = new Field(this.alias, dataType);
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        Field[] fields = rowMeta.getFields();
        Field[] newFields = new Field[fields.length + 1];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        newFields[fields.length] = this.newField;
        return new RowMeta(newFields);
    }

    @Override
    protected InnerRowIterator createIterator() {
        this.checkClosed();
        if (this.calc instanceof ConstantCalc) {
            return new ConstantIter(((ConstantCalc)this.calc).getValue());
        }
        return new MyIter();
    }

    @Override
    public void realClose() {
    }

    class ConstantIter
    extends InnerRowIterator {
        private Iterator<Row> inner;
        private RowMeta rowMeta;
        private int newIndex;
        private Object value;

        public ConstantIter(Object value) {
            this.value = value;
            this.inner = AddFieldDataSet.this.getInput(0).innerIterator();
            this.rowMeta = AddFieldDataSet.this.getRowMeta();
            this.newIndex = this.rowMeta.getFieldCount() - 1;
        }

        @Override
        public boolean _hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Row _next() {
            Row innerRow = this.inner.next();
            return new NewFieldValueRow(this.rowMeta, innerRow, this.newIndex, this.value);
        }
    }

    class MyIter
    extends InnerRowIterator {
        private Iterator<Row> inner;
        private RowMeta rowMeta;
        private int newIndex;

        public MyIter() {
            this.inner = AddFieldDataSet.this.getInput(0).innerIterator();
            this.rowMeta = AddFieldDataSet.this.getRowMeta();
            this.newIndex = this.rowMeta.getFieldCount() - 1;
        }

        @Override
        public boolean _hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Row _next() {
            Row innerRow = this.inner.next();
            Supplier<Object> valueSupplier = () -> AddFieldDataSet.this.calc.execute(innerRow, null);
            return new NewFieldRow(this.rowMeta, innerRow, this.newIndex, valueSupplier);
        }
    }
}

