/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.addfield;

import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.NewFieldsRow;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;

public class AddFieldsDataSet
extends AbstractDataSet {
    private String[] exprs;
    private String[] aliases;
    private Field[] newFields;
    private Calc[] calcs;
    private int innerIndex;

    public AddFieldsDataSet(AbstractDataSet inner, String[] exprs, String[] aliases) {
        this("AddFields", inner, exprs, aliases);
    }

    public AddFieldsDataSet(String dataSetName, AbstractDataSet inner, String[] exprs, String[] aliases) {
        super(dataSetName, inner);
        this.exprs = exprs;
        this.aliases = aliases;
        this.init();
    }

    private void init() {
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        this.innerIndex = rowMeta.getFieldCount() - 1;
        ExprParser parser = new ExprParser(rowMeta);
        this.calcs = new Calc[this.exprs.length];
        this.newFields = new Field[this.exprs.length];
        Expr newExpr = null;
        for (int i = 0; i < this.exprs.length; ++i) {
            newExpr = parser.parse(this.exprs[i]);
            this.calcs[i] = CalcCompiler.compile(rowMeta, newExpr);
            DataType dataType = newExpr.getDataType();
            this.newFields[i] = new Field(this.aliases[i], dataType);
        }
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        Field[] fields = rowMeta.getFields();
        Field[] newFields = new Field[fields.length + this.exprs.length];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        for (int i = 0; i < this.exprs.length; ++i) {
            newFields[fields.length + i] = this.newFields[i];
        }
        return new RowMeta(newFields);
    }

    @Override
    protected InnerRowIterator createIterator() {
        this.checkClosed();
        return new MyIter();
    }

    @Override
    public void realClose() {
    }

    class MyIter
    extends InnerRowIterator {
        private Iterator<Row> inner;
        private RowMeta rowMeta;

        public MyIter() {
            this.inner = AddFieldsDataSet.this.getInput(0).innerIterator();
            this.rowMeta = AddFieldsDataSet.this.getRowMeta();
        }

        @Override
        public boolean _hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Row _next() {
            Row innerRow = this.inner.next();
            return new NewFieldsRow(this.rowMeta, innerRow, AddFieldsDataSet.this.innerIndex, AddFieldsDataSet.this.calcs);
        }
    }
}

