/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.addfield;

import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.AddNullFieldRow;
import kd.bos.algo.dataset.InnerRowIterator;

public class AddNullFieldDataSet
extends AbstractDataSet {
    private String[] aliases;
    private Field[] newFields;
    private DataType dataType = DataType.NullType;

    public AddNullFieldDataSet(AbstractDataSet inner, String ... aliases) {
        super("AddNull", inner);
        this.aliases = aliases;
        this.init();
    }

    private void init() {
        this.newFields = new Field[this.aliases.length];
        for (int i = 0; i < this.aliases.length; ++i) {
            this.newFields[i] = new Field(this.aliases[i], this.dataType);
        }
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        Field[] fields = rowMeta.getFields();
        Field[] allFields = new Field[fields.length + this.newFields.length];
        System.arraycopy(fields, 0, allFields, 0, fields.length);
        for (int i = 0; i < this.newFields.length; ++i) {
            allFields[fields.length + i] = this.newFields[i];
        }
        return new RowMeta(allFields);
    }

    @Override
    protected InnerRowIterator createIterator() {
        this.checkClosed();
        return new MyIter();
    }

    @Override
    public void realClose() {
    }

    private class MyIter
    extends InnerRowIterator {
        private Iterator<Row> inner;
        private RowMeta rowMeta;

        public MyIter() {
            this.inner = AddNullFieldDataSet.this.getInput(0).innerIterator();
            this.rowMeta = AddNullFieldDataSet.this.getRowMeta();
        }

        @Override
        public boolean _hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Row _next() {
            Row innerRow = this.inner.next();
            return new AddNullFieldRow(this.rowMeta, innerRow);
        }
    }
}

