/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.addfield;

import java.util.Iterator;
import java.util.function.Supplier;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.NewFieldRow;
import kd.bos.algo.datatype.NumericType;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;
import kd.bos.algo.util.Aggregator;

public class BalanceDataSet
extends AbstractDataSet {
    private String expr;
    private String alias;
    private Field newField;
    private Calc calc;

    public BalanceDataSet(AbstractDataSet inner, String expr, String alias) {
        this("Balance", inner, expr, alias);
    }

    public BalanceDataSet(String dataSetName, AbstractDataSet inner, String expr, String alias) {
        super(dataSetName, inner);
        this.expr = expr;
        this.alias = alias;
        this.init();
    }

    private void init() {
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        ExprParser parser = new ExprParser(rowMeta);
        Expr newExpr = parser.parse(this.expr);
        this.calc = CalcCompiler.compile(rowMeta, newExpr);
        DataType dataType = newExpr.getDataType();
        if (!(dataType instanceof NumericType)) {
            throw new AlgoException("addBalance Field should be numeric type.");
        }
        this.newField = new Field(this.alias, dataType);
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        Field[] fields = rowMeta.getFields();
        Field[] newFields = new Field[fields.length + 1];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        newFields[fields.length] = this.newField;
        return new RowMeta(newFields);
    }

    @Override
    protected InnerRowIterator createIterator() {
        this.checkClosed();
        return new MyIter();
    }

    @Override
    public void realClose() {
    }

    private class MyIter
    extends InnerRowIterator {
        private Aggregator agg = Aggregator.getAggregator("sum");
        private Object aggValue = null;
        private Iterator<Row> inner;
        private RowMeta rowMeta;
        private int newIndex;

        public MyIter() {
            this.inner = BalanceDataSet.this.getInput(0).innerIterator();
            this.rowMeta = BalanceDataSet.this.getRowMeta();
            this.newIndex = this.rowMeta.getFieldCount() - 1;
        }

        @Override
        public boolean _hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Row _next() {
            Row innerRow = this.inner.next();
            Object newValue = BalanceDataSet.this.calc.execute(innerRow, null);
            this.aggValue = this.agg.appendValue(this.aggValue, newValue);
            Supplier<Object> valueSupplier = () -> this.agg.getValue(this.aggValue);
            return new NewFieldRow(this.rowMeta, innerRow, this.newIndex, valueSupplier);
        }
    }
}

