/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.builder;

import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreDataSet;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.env.Environment;

public class StoreDataSetBuilder
implements DataSetBuilder {
    private RowMeta rowMeta;
    private Environment env;
    private Store store;

    public StoreDataSetBuilder(Environment env, RowMeta rowMeta) {
        this.env = env;
        this.rowMeta = rowMeta;
        this.store = StoreFactory.createDataSetBackStore(rowMeta);
    }

    @Override
    public void append(Object[] values) {
        this.store.write(RowFactory.createRow(this.rowMeta, values));
    }

    @Override
    public void append(Row row) {
        this.store.write(row);
    }

    @Override
    public DataSet build() {
        return new StoreDataSet(this.env, this.store);
    }
}

