/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache.kv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.SimpleMetaImpl;
import kd.bos.algo.dataset.cache.kv.KVDeserializer;
import kd.bos.algo.dataset.cache.kv.KVSerializerFactory;
import kd.bos.algo.exception.AlgoExceedAllowMaxRowsException;
import kd.bos.algo.serde.RowSerde;
import kd.bos.algo.storage.CacheReader;
import kd.bos.algo.storage.CacheStorage;
import kd.bos.algo.storage.CacheWriter;
import kd.bos.algo.storage.MainThread;
import kd.bos.algo.storage.Page;
import kd.bos.algo.storage.ZipReader;
import kd.bos.algo.storage.ZipWriter;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class KVSpiImpl
implements DataSetCacheSpi {
    private CacheStorage storage;
    private String compressor;
    private RowSerde rowSerde;
    private Timer timer;
    private Meter meter;
    private Meter errorMeter;
    private Timer timerByName;
    private Meter meterByName;
    private Meter errorByName;
    private Appender appender;
    private String serializeType = AlgoConfiguration.DATASETCACHE_SERIALIZE_TYPE.getString();
    private MainThread mainThread = null;

    public KVSpiImpl(CacheStorage storage) {
        this.storage = storage;
        this.timer = MetricSystem.timer((String)"kd.metrics.algo.cache.saveTimer");
        this.meter = MetricSystem.meter((String)"kd.metrics.algo.cache.saveMeter");
        this.errorMeter = MetricSystem.meter((String)"kd.metrics.algo.cache.saveMeter.error");
        this.timerByName = MetricSystem.timer((String)("kd.metrics.algo.cache.saveTimer." + storage.getName()));
        this.meterByName = MetricSystem.meter((String)("kd.metrics.algo.cache.saveMeter." + storage.getName()));
        this.errorByName = MetricSystem.meter((String)("kd.metrics.algo.cache.saveMeter.error." + storage.getName()));
        this.compressor = System.getProperty("algo.storage.compressor");
    }

    private String getCacheId(CacheHint hint) {
        if (hint.getCacheId() != null) {
            return hint.getCacheId();
        }
        return this.generateId();
    }

    private String generateId() {
        return "datasetcache-" + UUID.randomUUID().toString().replace("-", "");
    }

    public String getPageKey(int page) {
        return "page" + page;
    }

    @Override
    public void open(RowMeta rowMeta, CacheHint hint) {
        if (this.rowSerde == null) {
            this.rowSerde = RowSerde.Factory.get(rowMeta);
        }
        this.appender = new Appender();
        this.appender.rowMeta = rowMeta;
        this.appender.hint = hint;
        this.appender.cacheId = this.getCacheId(hint);
        this.appender.pageSize = hint.getPageSize();
        try {
            this.appender.writer = this.createWriter(this.appender.cacheId, hint.getTimeout());
        }
        catch (IOException e) {
            this.errorMeter.mark();
            this.errorByName.mark();
            throw new AlgoException("can't write page: " + e.getMessage(), e);
        }
        this.appender.page = new Page(0, this.rowSerde);
    }

    private boolean isExceedAllowMaxRows(int rowCount, CacheHint hint) {
        if (rowCount > hint.getAllowMaxRows()) {
            if (hint.isThrowExceptionWhenExceedAllowMaxRows()) {
                throw new AlgoExceedAllowMaxRowsException("DataSetCache exceed allow max rows:[rowCount:" + rowCount + ",allowMaxRows:" + hint.getAllowMaxRows() + "]");
            }
            return true;
        }
        return false;
    }

    @Override
    public void append(Iterator<Row> iter) {
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    @Override
    public void append(Row row) {
        try {
            if (this.isExceedAllowMaxRows(this.appender.rowCount, this.appender.hint)) {
                return;
            }
            this.appender.page.addRow(this.appender.rowMeta, row);
            this.appender.rowCount++;
            if (this.appender.rowCount % this.appender.pageSize == 0) {
                if (this.mainThread == null) {
                    this.mainThread = new MainThread(this.appender.writer, this.appender.cacheId, this.appender.rowMeta, this.appender.hint, this.storage);
                }
                this.mainThread.addPage(this.appender.page);
                this.appender.page = new Page(++this.appender.pageId, this.rowSerde);
            }
        }
        catch (Exception e) {
            AlgoException error;
            AlgoException algoException = error = e instanceof AlgoException ? (AlgoException)e : new AlgoException("Save error", e);
            if (this.mainThread != null) {
                this.mainThread.cancelOnException(error);
            } else {
                this.delete(this.appender.cacheId, false);
            }
            throw error;
        }
    }

    @Override
    public DataSetCacheMeta finish() {
        if (this.appender.page.getRowCount() > 0) {
            if (this.mainThread != null) {
                this.mainThread.addPage(this.appender.page);
            } else {
                try {
                    this.writePage(this.appender.writer, this.appender.page);
                }
                catch (Exception e) {
                    this.errorMeter.mark();
                    this.errorByName.mark();
                    AlgoException error = e instanceof AlgoException ? (AlgoException)e : new AlgoException("Save error", e);
                    this.delete(this.appender.cacheId, false);
                    throw error;
                }
            }
        }
        try {
            if (this.mainThread != null) {
                this.mainThread.end();
                this.mainThread.waitDone();
                if (this.mainThread.getError() != null) {
                    throw this.mainThread.getError();
                }
            }
            SimpleMetaImpl meta = new SimpleMetaImpl(this.appender.cacheId, this.appender.rowMeta, this.appender.rowCount, this.appender.hint.getPageSize(), this.appender.hint.getStorageType());
            meta.setCompressor(this.compressor);
            this.writeMeta(this.appender.writer, meta);
            this.writeTimeout(this.appender.writer, this.appender.hint);
            this.appender.writer.flush();
            return meta;
        }
        catch (Exception e) {
            this.errorMeter.mark();
            this.errorByName.mark();
            AlgoException error = e instanceof AlgoException ? (AlgoException)e : new AlgoException("Save error", e);
            this.delete(this.appender.cacheId, false);
            throw error;
        }
    }

    @Override
    public DataSetCacheMeta save(RowMeta rowMeta, Iterator<Row> iter, CacheHint hint) {
        if (this.rowSerde == null) {
            this.rowSerde = RowSerde.Factory.get(rowMeta);
        }
        Timer.Context context = this.timer.time();
        Timer.Context contextByName = this.timerByName.time();
        String cacheId = this.getCacheId(hint);
        try {
            CacheWriter writer = this.createWriter(cacheId, hint.getTimeout());
            TraceSpan span = Tracer.getCurrentSpan();
            int rowCount = this.writeRows(span, writer, cacheId, rowMeta, iter, hint);
            this.meter.mark((long)rowCount);
            this.meterByName.mark((long)rowCount);
            SimpleMetaImpl meta = new SimpleMetaImpl(cacheId, rowMeta, rowCount, hint.getPageSize(), hint.getStorageType());
            meta.setCompressor(this.compressor);
            this.writeMeta(writer, meta);
            this.writeTimeout(writer, hint);
            writer.flush();
            SimpleMetaImpl simpleMetaImpl = meta;
            return simpleMetaImpl;
        }
        catch (Exception e) {
            AlgoException error;
            this.errorMeter.mark();
            this.errorByName.mark();
            AlgoException algoException = error = e instanceof AlgoException ? (AlgoException)e : new AlgoException("Save error", e);
            if (this.mainThread != null) {
                this.mainThread.cancelOnException(error);
            } else {
                this.delete(cacheId, false);
            }
            throw error;
        }
        finally {
            context.stop();
            contextByName.stop();
        }
    }

    private void writeTimeout(CacheWriter writer, CacheHint hint) throws IOException {
        long timeout = hint.getTimeout();
        long createTime = System.currentTimeMillis();
        writer.putMeta("timeout", ("" + timeout).getBytes(StandardCharsets.UTF_8));
        writer.putMeta("createTime", ("" + createTime).getBytes(StandardCharsets.UTF_8));
    }

    private void writeMeta(CacheWriter writer, SimpleMetaImpl meta) throws IOException {
        String key2 = "meta";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(meta);
        out.flush();
        writer.putMeta(key2, out.toByteArray());
    }

    private int writeRows(TraceSpan span, CacheWriter writer, String key1, RowMeta rowMeta, Iterator<Row> iter, CacheHint hint) throws IOException {
        long t1 = System.currentTimeMillis();
        int rowCount = 0;
        int pageSize = hint.getPageSize();
        int pageId = 0;
        Page page = new Page(pageId, this.rowSerde);
        while (iter.hasNext()) {
            Row row = iter.next();
            if (this.isExceedAllowMaxRows(rowCount, hint)) continue;
            page.addRow(rowMeta, row);
            if (++rowCount % pageSize != 0) continue;
            if (this.mainThread == null) {
                this.mainThread = new MainThread(writer, key1, rowMeta, hint, this.storage);
            }
            this.mainThread.addPage(page);
            page = new Page(++pageId, this.rowSerde);
        }
        if (rowCount % pageSize > 0 && this.mainThread != null) {
            this.mainThread.addPage(page);
        }
        if (this.mainThread != null) {
            this.mainThread.end();
            this.mainThread.waitDone();
            if (this.mainThread.getError() != null) {
                throw this.mainThread.getError();
            }
        } else if (rowCount % pageSize > 0) {
            this.writePage(writer, page);
        }
        return rowCount;
    }

    private void writePage(CacheWriter writer, Page page) throws IOException {
        String key2 = this.getPageKey(page.getPageId());
        byte[] bytes = page.toByteArray();
        writer.put(key2, bytes);
    }

    @Override
    public DataSetCacheMeta getMeta(String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        try {
            CacheReader reader = this.createReader(id, null);
            if (reader == null) {
                return null;
            }
            byte[] bytes = reader.getMeta("meta");
            if (bytes == null) {
                return null;
            }
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return (DataSetCacheMeta)ois.readObject();
        }
        catch (Exception e) {
            throw new AlgoException("can't getMeta: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DataSetCacheMeta meta) {
        this.delete(meta.getId());
    }

    @Override
    public void delete(String id) {
        this.delete(id, true);
    }

    private void delete(String id, boolean throwOnException) {
        block2: {
            try {
                this.storage.delete(id);
            }
            catch (Exception e) {
                if (!throwOnException) break block2;
                throw new AlgoException(e, "error delete: " + e.getMessage(), new Object[0]);
            }
        }
    }

    @Override
    public List<Row> getList(DataSetCacheMeta meta, int begin, int length) {
        Throwable throwable = null;
        try (TraceSpan span = Tracer.create((String)"DataSet", (String)"Cache.KVSpi.getList");){
            int rowCount;
            RowMeta rowMeta;
            CacheReader reader;
            String id;
            block25: {
                id = meta.getId();
                span.addTag("id", id);
                span.addTag("begin", String.valueOf(begin));
                span.addTag("length", String.valueOf(length));
                try {
                    reader = this.createReader(id, meta.getCompressor());
                    rowMeta = meta.getRowMeta();
                    rowCount = meta.getRowCount();
                    if (rowCount == 0) {
                        List<Row> list = Collections.emptyList();
                        return list;
                    }
                    if (rowCount >= begin + length || (length = rowCount - begin) > 0) break block25;
                }
                catch (IOException e) {
                    try {
                        throw new AlgoException("error when get dataset cache iterator.", e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                List<Row> list = Collections.emptyList();
                return list;
            }
            int pageSize = meta.getPageSize();
            int pageId = begin / pageSize;
            int offset = begin % pageSize;
            String key2 = this.getPageKey(pageId);
            byte[] bytes = reader.get(key2);
            if (bytes == null) {
                throw AlgoException.create("kv cache not exists for id:%s,pageId:%d", id, pageId);
            }
            KVDeserializer kvDeserializer = KVSerializerFactory.getKVDeserializer(this.serializeType, rowMeta, this.rowSerde, bytes);
            ArrayList<Row> result = new ArrayList<Row>();
            int index = 0;
            int add = 0;
            while (add < length && begin + add < rowCount) {
                Row row = (Row)kvDeserializer.deserialize(index);
                if (index < offset) {
                    ++index;
                    continue;
                }
                result.add(row);
                if (++index % pageSize != 0 || begin + ++add >= rowCount) continue;
                offset = 0;
                kvDeserializer.close();
                key2 = this.getPageKey(++pageId);
                bytes = reader.get(key2);
                kvDeserializer = KVSerializerFactory.getKVDeserializer(this.serializeType, rowMeta, this.rowSerde, bytes);
            }
            ArrayList<Row> arrayList = result;
            return arrayList;
        }
    }

    private CacheWriter createWriter(String cacheId, long timeout) throws IOException {
        return ZipWriter.wrapToZIPWriter(this.storage.create(cacheId, timeout), this.compressor);
    }

    private CacheReader createReader(String cacheId, String compressor) throws IOException {
        return ZipReader.WrapToZIPReader(this.storage.open(cacheId), compressor);
    }

    class Appender {
        private RowMeta rowMeta;
        private CacheHint hint;
        private String cacheId;
        private CacheWriter writer;
        private int pageSize;
        private int rowCount;
        private int pageId;
        private Page page;

        Appender() {
        }
    }
}

