/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache.kv;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.cache.kv.KVDeserializer;

public class PageKVDeserializer
implements KVDeserializer<Row> {
    private RowMeta rowMeta;
    private List<Object[]> rowValues;

    public PageKVDeserializer(RowMeta rowMeta, byte[] bytes) {
        this.rowMeta = rowMeta;
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
             ObjectInputStream ois = new ObjectInputStream(in);){
            this.rowValues = (List)ois.readObject();
        }
        catch (Exception e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public Row deserialize(int index) {
        return RowFactory.createRow(this.rowMeta, this.rowValues.get(index));
    }

    @Override
    public void close() {
    }
}

