/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache.kv;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.cache.kv.KVSerializer;

public class PageKVSerializer
implements KVSerializer<Row> {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private ObjectOutputStream oos;
    private List<Object[]> rowValues;

    public PageKVSerializer() {
        try {
            this.oos = new ObjectOutputStream(this.baos);
        }
        catch (Exception e) {
            throw new AlgoException(e);
        }
        this.rowValues = new ArrayList<Object[]>(5000);
    }

    @Override
    public void serialize(Row row, RowMeta rowMeta) {
        this.rowValues.add(((AbstractRow)row).values());
    }

    @Override
    public byte[] toByte() throws IOException {
        try {
            this.oos.writeObject(this.rowValues);
            this.oos.flush();
            byte[] byArray = this.baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new AlgoException(e);
        }
        finally {
            if (this.oos != null) {
                this.oos.close();
            }
            if (this.baos != null) {
                this.baos.close();
            }
        }
    }
}

