/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache.kv;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.cache.kv.KVSerializer;
import kd.bos.algo.serde.RowSerde;

public class RowKVSerializer
implements KVSerializer<Row> {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private DataOutputStream dout = new DataOutputStream(this.baos);
    private RowSerde rowSerde;

    public RowKVSerializer(RowSerde rowSerde) {
        this.rowSerde = rowSerde;
    }

    @Override
    public void serialize(Row row, RowMeta rowMeta) {
        this.rowSerde.write(rowMeta, row, this.dout);
    }

    @Override
    public byte[] toByte() throws IOException {
        try {
            this.dout.flush();
            byte[] byArray = this.baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new AlgoException(e);
        }
        finally {
            if (this.dout != null) {
                this.dout.close();
            }
            if (this.baos != null) {
                this.baos.close();
            }
        }
    }
}

