/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.groupby.GroupByCountDistinctDataSet;
import kd.bos.algo.dataset.groupby.GroupbyInfo;
import kd.bos.algo.dataset.groupby.NullGroupsDataSet;
import kd.bos.algo.dataset.groupby.OrderBasedGroupByDataSet;
import kd.bos.algo.dataset.groupby.SingleGroupByDataSet;
import kd.bos.algo.dataset.groupby.SmartGroupByDataSet;
import kd.bos.algo.dataset.reduce.ReduceGroupDataSet;
import kd.bos.algo.dataset.reduce.ReduceGroupWithCollectDataSet;
import kd.bos.algo.dataset.store.mm.MMMapLimit;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.sql.parser.SqlParser;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.ExprList;
import kd.bos.algo.sql.tree.Literal;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.UnaryExpr;
import kd.bos.algo.sql.tree.agg.AvgExpr;
import kd.bos.algo.sql.tree.agg.CountDistinctExpr;
import kd.bos.algo.sql.tree.agg.CountExpr;
import kd.bos.algo.sql.tree.agg.CustomizedAggExpr;
import kd.bos.algo.sql.tree.agg.GroupConcatExpr;
import kd.bos.algo.sql.tree.agg.MaxExpr;
import kd.bos.algo.sql.tree.agg.MaxPExpr;
import kd.bos.algo.sql.tree.agg.MinExpr;
import kd.bos.algo.sql.tree.agg.MinPExpr;
import kd.bos.algo.sql.tree.agg.SumExpr;

public class GroupbyDataSetBuilder
implements GroupbyDataSet {
    private AbstractDataSet innerDataSet;
    private GroupbyInfo info = new GroupbyInfo();
    private SqlParser parser = new SqlParser();
    private boolean hasCompoundAgg;
    private boolean isCountDistinct;

    public GroupbyDataSetBuilder(AbstractDataSet innerDataSet, String[] groupFields) {
        this(innerDataSet, groupFields, null);
    }

    public GroupbyDataSetBuilder(AbstractDataSet innerDataSet, String[] groupFields, boolean[] orderByDescs) {
        this.innerDataSet = innerDataSet;
        if (groupFields != null && groupFields.length > 0) {
            for (String field : groupFields) {
                this.info.addGroup(field);
            }
        }
        this.info.setOrderByDescs(orderByDescs);
    }

    @Override
    public GroupbyDataSet sum(String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        Optional<NodeLocation> op = Optional.of(new NodeLocation(field));
        UnaryExpr expr = new SumExpr(op, child);
        if (alias != null) {
            expr = new Alias(op, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        return this;
    }

    @Override
    public GroupbyDataSet avg(String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        Optional<NodeLocation> op = Optional.of(new NodeLocation(field));
        UnaryExpr expr = new AvgExpr(op, child);
        if (alias != null) {
            expr = new Alias(op, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        this.hasCompoundAgg = true;
        return this;
    }

    @Override
    public GroupbyDataSet max(String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        Optional<NodeLocation> op = Optional.of(new NodeLocation(field));
        UnaryExpr expr = new MaxExpr(op, child);
        if (alias != null) {
            expr = new Alias(op, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        return this;
    }

    @Override
    public GroupbyDataSet agg(CustomAggFunction<?> aggFunc, String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        Optional<NodeLocation> op = Optional.of(new NodeLocation(field));
        UnaryExpr expr = new CustomizedAggExpr(op, aggFunc, child);
        if (alias != null) {
            expr = new Alias(op, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        this.hasCompoundAgg = true;
        return this;
    }

    @Override
    public GroupbyDataSet groupConcat(String field) {
        return this.groupConcat(field, null);
    }

    @Override
    public GroupbyDataSet groupConcat(String field, String alias) {
        return this.groupConcat(field, alias, ",");
    }

    @Override
    public GroupbyDataSet groupConcat(String field, String alias, String separator) {
        Expr child = this.parser.parseExpr(field);
        Optional<NodeLocation> op = Optional.of(new NodeLocation(field));
        UnaryExpr expr = new GroupConcatExpr(op, child, separator);
        if (alias != null) {
            expr = new Alias(op, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        return this;
    }

    @Override
    public GroupbyDataSet min(String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        Optional<NodeLocation> op = Optional.of(new NodeLocation(field));
        UnaryExpr expr = new MinExpr(op, child);
        if (alias != null) {
            expr = new Alias(op, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        return this;
    }

    @Override
    public GroupbyDataSet maxP(String expr, String propertyExpr, String alias) {
        Expr ex = this.parser.parseExpr(expr);
        Expr pex = this.parser.parseExpr(propertyExpr);
        Optional<NodeLocation> op = Optional.of(new NodeLocation(expr));
        ex = new MaxPExpr(op, ex, pex);
        if (alias != null) {
            ex = new Alias(op, ex, alias);
        }
        this.info.addAgg(ex);
        this.hasCompoundAgg = true;
        return this;
    }

    @Override
    public GroupbyDataSet minP(String expr, String propertyExpr, String alias) {
        Expr ex = this.parser.parseExpr(expr);
        Expr pex = this.parser.parseExpr(propertyExpr);
        Optional<NodeLocation> op = Optional.of(new NodeLocation(expr));
        ex = new MinPExpr(op, ex, pex);
        if (alias != null) {
            ex = new Alias(op, ex, alias);
        }
        this.info.addAgg(ex);
        this.hasCompoundAgg = true;
        return this;
    }

    @Override
    public GroupbyDataSet count(String alias) {
        Optional<NodeLocation> op = Optional.of(new NodeLocation(""));
        Literal child = new Literal(op, 1, (DataType)DataType.IntegerType);
        UnaryExpr expr = new CountExpr(op, child);
        if (alias == null) {
            alias = "count";
        }
        expr = new Alias(op, (Expr)expr, alias);
        this.info.addAgg(expr);
        return this;
    }

    @Override
    public DataSet finish() {
        if (this.isCountDistinct) {
            return new GroupByCountDistinctDataSet(this.innerDataSet, this.info, MMMapLimit.exceedLimit());
        }
        if (this.info.getGroups() == null) {
            return new SingleGroupByDataSet(this.innerDataSet, this.info);
        }
        if (this.groupIsAllNulls()) {
            return new NullGroupsDataSet(this.innerDataSet, this.info);
        }
        if (this.hasCompoundAgg) {
            return new OrderBasedGroupByDataSet(this.innerDataSet, this.info);
        }
        if (!MMMapLimit.exceedLimit()) {
            return new SmartGroupByDataSet(this.innerDataSet, this.info);
        }
        return new OrderBasedGroupByDataSet(this.innerDataSet, this.info);
    }

    @Override
    public DataSet reduceGroup(ReduceGroupFunction fun) {
        return new ReduceGroupDataSet(this.innerDataSet, this.info, fun);
    }

    @Override
    public DataSet reduceGroup(ReduceGroupFunctionWithCollector fun) {
        return new ReduceGroupWithCollectDataSet(this.innerDataSet, this.info, fun);
    }

    private boolean groupIsAllNulls() {
        String[] orderKeys = this.info.getGroups();
        RowMeta rowMeta = this.innerDataSet.getRowMeta();
        for (int i = 0; i < orderKeys.length; ++i) {
            DataType dataType = rowMeta.getField(orderKeys[i]).getDataType();
            if (dataType instanceof NullType) continue;
            return false;
        }
        return true;
    }

    @Override
    public GroupbyDataSet sum(String field) {
        return this.sum(field, null);
    }

    @Override
    public GroupbyDataSet avg(String field) {
        return this.avg(field, null);
    }

    @Override
    public GroupbyDataSet max(String field) {
        return this.max(field, null);
    }

    @Override
    public GroupbyDataSet min(String field) {
        return this.min(field, null);
    }

    @Override
    public GroupbyDataSet maxP(String field, String propertyField) {
        return this.maxP(field, propertyField, null);
    }

    @Override
    public GroupbyDataSet minP(String field, String propertyField) {
        return this.minP(field, propertyField, null);
    }

    @Override
    public GroupbyDataSet count() {
        return this.count(null);
    }

    @Override
    public GroupbyDataSet countDistinct(String[] field) {
        return this.countDistinct(field, null);
    }

    @Override
    public GroupbyDataSet countDistinct(String[] exprStr, String alias) {
        int[] groupIndices;
        this.check(exprStr);
        if (alias == null || alias.length() == 0) {
            alias = exprStr.length == 1 ? exprStr[0] : "countdistinct";
        }
        RowMeta rowMeta = this.innerDataSet.getRowMeta();
        Expr[] children = new Expr[exprStr.length];
        int[] filedIndex = new int[exprStr.length];
        for (int i = 0; i < exprStr.length; ++i) {
            Expr child;
            children[i] = child = this.parser.parseExpr(exprStr[i]);
            filedIndex[i] = rowMeta.getFieldIndex(child.toString());
        }
        String[] groups = this.info.getGroups();
        if (groups == null || this.groupIsAllNulls()) {
            groupIndices = new int[]{};
        } else {
            groupIndices = new int[groups.length];
            for (int i = 0; i < groupIndices.length; ++i) {
                groupIndices[i] = rowMeta.getFieldIndex(groups[i]);
            }
        }
        Optional<NodeLocation> nodeLocation = Optional.of(new NodeLocation(""));
        CountDistinctExpr expr = new CountDistinctExpr(nodeLocation, (Expr)new ExprList(nodeLocation, children), groupIndices, filedIndex);
        Alias aliasExpr = new Alias(nodeLocation, (Expr)expr, alias);
        this.info.addAgg(aliasExpr);
        this.isCountDistinct = true;
        return this;
    }

    private void check(String[] exprStr) {
        if (this.isCountDistinct) {
            throw new AlgoException("not support more than one countdistinct at present");
        }
        if (exprStr == null || exprStr.length == 0) {
            throw new AlgoException("distinct field must not null");
        }
    }
}

