/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.groupby.ArrayKeyComparator;
import kd.bos.algo.dataset.groupby.GroupByRow;
import kd.bos.algo.dataset.store.HashMapStore;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.ArrayKey;

public class LimitedHashGrouper {
    protected Iterator<Row> iter;
    protected Aggregator[] aggregators;
    protected boolean[] descs;
    protected RowMeta targetRowMeta;
    protected Calc[] groupCalcs;
    protected Calc[] aggCalcs;
    private HashMapStore<ArrayKey, Object[]> mapStore;

    public LimitedHashGrouper(Iterator<Row> iter, Calc[] groupCalcs, boolean[] descs, Calc[] aggCalcs, Aggregator[] aggregators, RowMeta targetRowMeta) {
        this.iter = iter;
        this.groupCalcs = groupCalcs;
        this.descs = descs;
        this.aggCalcs = aggCalcs;
        this.aggregators = aggregators;
        this.targetRowMeta = targetRowMeta;
    }

    public boolean build(int limit) {
        if (this.mapStore != null) {
            this.mapStore.close();
        }
        this.mapStore = StoreFactory.createHashMapStore(this.groupCalcs.length + this.aggCalcs.length);
        while (this.iter.hasNext()) {
            if (this.mapStore.size() > limit) {
                return false;
            }
            Row row = this.iter.next();
            this.processRow(row);
        }
        return true;
    }

    private void processRow(Row row) {
        Object[] keys = new Object[this.groupCalcs.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.groupCalcs[i].execute(row, null);
        }
        ArrayKey gk = new ArrayKey(keys);
        Object[] aggValues = this.mapStore.get(gk);
        if (aggValues == null) {
            aggValues = new Object[this.aggregators.length];
            for (int i = 0; i < this.aggregators.length; ++i) {
                Object v = this.aggCalcs[i].execute(row, null);
                aggValues[i] = this.aggregators[i].appendValue(aggValues[i], v);
            }
            this.mapStore.put(gk, aggValues);
        } else {
            for (int i = 0; i < this.aggregators.length; ++i) {
                Object v = this.aggCalcs[i].execute(row, null);
                aggValues[i] = this.aggregators[i].appendValue(aggValues[i], v);
            }
        }
    }

    private TreeMap sort() {
        TreeMap<ArrayKey, Object[]> tm = new TreeMap<ArrayKey, Object[]>(new ArrayKeyComparator(this.descs));
        Iterator<Map.Entry<ArrayKey, Object[]>> iter = this.mapStore.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<ArrayKey, Object[]> entry = iter.next();
            tm.put(entry.getKey(), entry.getValue());
        }
        this.mapStore.close();
        this.mapStore = null;
        return tm;
    }

    public InnerRowIterator getIterator(boolean sort) {
        final Iterator<Map.Entry<ArrayKey, Object>> mapIter = sort ? this.sort().entrySet().iterator() : this.mapStore.entryIterator();
        return new InnerRowIterator(){

            @Override
            public boolean _hasNext() {
                return mapIter.hasNext();
            }

            @Override
            public Row _next() {
                Map.Entry entry = (Map.Entry)mapIter.next();
                return LimitedHashGrouper.this.makeTargetRow((ArrayKey)entry.getKey(), (Object[])entry.getValue());
            }
        };
    }

    public void close() {
        if (this.mapStore != null) {
            this.mapStore.close();
            this.mapStore = null;
        }
    }

    protected Row makeTargetRow(ArrayKey groupKeys, Object[] aggValues) {
        return new GroupByRow(this.targetRowMeta, groupKeys, aggValues, this.aggregators);
    }
}

