/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.groupby.FunctionParam;
import kd.bos.algo.dataset.groupby.GroupByRow;
import kd.bos.algo.dataset.groupby.GroupParam;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.ArrayKey;
import kd.bos.algo.util.Constants;
import kd.bos.algo.util.ResultEnum;

class MergedCountDistinctIterator
extends InnerRowIterator {
    private Iterator<Row> iter;
    private Aggregator[] aggregators;
    private RowMeta targetRowMeta;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ArrayKey lastMapKey;
    private Object[] lastMapValue;
    private int lastCompareResult = Integer.MIN_VALUE;
    private Object[] lastIterAggValues = null;
    private ArrayKey lastIterGroupKeys = null;
    private String lastIterDistinctKey = null;
    private Calc[] groupCalcs;
    private Calc[] aggCalcs;
    private int aggLength;
    private int[] distinctFieldIndices;
    private boolean groupIsAllNulls;
    private Iterator<Map.Entry<ArrayKey, Object[]>> mapIterator;

    public MergedCountDistinctIterator(Iterator<Row> iter, FunctionParam param, RowMeta targetRowMeta, GroupParam groupParam) {
        this.iter = iter;
        this.groupCalcs = param.getGroupCalcs();
        this.aggregators = param.getAggregators();
        this.aggLength = this.aggregators.length;
        this.targetRowMeta = targetRowMeta;
        this.mapIterator = groupParam.getMapIterator();
        this.distinctFieldIndices = groupParam.getDistinctFieldIndices();
        this.aggCalcs = param.getAggCalcs();
        this.groupIsAllNulls = groupParam.isGroupIsAllNulls();
        this.firstIter();
    }

    @Override
    public boolean _hasNext() {
        return this.lastIterGroupKeys != null || this.lastMapKey != null;
    }

    @Override
    public Row _next() {
        return this.nextGroup();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final void firstIter() {
        ArrayKey gk;
        Row row = this.iter.next();
        this.lastIterGroupKeys = gk = this.initGroupKey(row);
        Object[] aggValues = this.initAggValuesAndMoveMap(gk, true);
        this.aggValue(aggValues, row);
        this.lastIterAggValues = aggValues;
    }

    private Object[] initAggValuesAndMoveMap(ArrayKey gk, boolean nextMapRow) {
        Object[] aggValues;
        if (nextMapRow) {
            if (this.mapIterator.hasNext()) {
                Map.Entry<ArrayKey, Object[]> next = this.mapIterator.next();
                ArrayKey key = next.getKey();
                this.lastCompareResult = gk == null ? 1 : key.compareTo(gk);
                aggValues = this.lastCompareResult == 0 ? next.getValue() : new Object[this.aggLength];
                this.lastMapKey = key;
                this.lastMapValue = next.getValue();
            } else {
                aggValues = new Object[this.aggLength];
                this.lastMapKey = null;
                this.lastMapValue = null;
                this.lastCompareResult = Integer.MIN_VALUE;
            }
        } else if (this.lastMapKey != null) {
            this.lastCompareResult = this.lastMapKey.compareTo(gk);
            aggValues = this.lastCompareResult == 0 ? this.lastMapValue : new Object[this.aggLength];
        } else {
            aggValues = new Object[this.aggLength];
        }
        return aggValues;
    }

    private void aggValue(Object[] aggValues, Row row) {
        String countDistinctKey = this.initCountDistinctKey(row);
        for (int i = 0; i < this.aggLength; ++i) {
            String name = this.aggregators[i].name;
            Object value = this.aggCalcs[i].execute(row, null);
            if ("countdistinct".equalsIgnoreCase(name)) {
                value = value == ResultEnum.NOT_EXISTS && (this.lastIterDistinctKey == null || !this.lastIterDistinctKey.equalsIgnoreCase(countDistinctKey)) ? Constants.ONE_LONG : Constants.ZERO_LONG;
            }
            aggValues[i] = this.aggregators[i].appendValue(aggValues[i], value);
        }
        this.lastIterDistinctKey = countDistinctKey;
    }

    private ArrayKey initGroupKey(Row row) {
        ArrayKey gk;
        if (this.groupCalcs == null) {
            gk = new ArrayKey(new Object[0]);
        } else {
            Object[] keys = new Object[this.groupCalcs.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = this.groupIsAllNulls ? "null" : this.groupCalcs[i].execute(row, null);
            }
            gk = new ArrayKey(keys);
        }
        return gk;
    }

    private String initCountDistinctKey(Row row) {
        StringBuilder builder = new StringBuilder();
        for (int index : this.distinctFieldIndices) {
            builder.append(this.getKey(row.get(index))).append("`");
        }
        return builder.toString();
    }

    private Object getKey(Object o) {
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).stripTrailingZeros().toPlainString();
        }
        if (o instanceof Date) {
            return this.sdf.format((Date)o);
        }
        return o;
    }

    public Row nextGroup() {
        if (!this._hasNext()) {
            return null;
        }
        if (this.lastIterGroupKeys == null) {
            Row targetRow = this.makeTargetRow(this.lastMapKey, this.lastMapValue);
            this.initAggValuesAndMoveMap(null, true);
            return targetRow;
        }
        if (this.lastMapKey == null) {
            Row targetRow = this.aggValue(false);
            return targetRow == null ? this.buildRow() : targetRow;
        }
        if (this.lastCompareResult > 0) {
            return this.aggValueAndCompare(false);
        }
        if (this.lastCompareResult < 0) {
            Row targetRow = this.makeTargetRow(this.lastMapKey, this.lastMapValue);
            Object[] aggValues = this.initAggValuesAndMoveMap(this.lastIterGroupKeys, true);
            this.appendAggreator(aggValues);
            return targetRow;
        }
        return this.aggValueAndCompare(true);
    }

    private void appendAggreator(Object[] aggValues) {
        if (this.lastIterAggValues != null && this.lastIterAggValues.length > 0 && this.lastCompareResult == 0) {
            Object[] newAggValues = new Object[this.lastIterAggValues.length];
            boolean hasUpdate = false;
            for (int i = 0; i < this.lastIterAggValues.length; ++i) {
                if (this.lastIterAggValues[i] == null) continue;
                newAggValues[i] = this.aggregators[i].appendAggregator(this.lastIterAggValues[i], aggValues[i]);
                hasUpdate = true;
            }
            if (hasUpdate) {
                this.lastIterAggValues = newAggValues;
            }
        }
    }

    private Row aggValueAndCompare(boolean nextMapRow) {
        Row targetRow = this.aggValue(nextMapRow);
        if (targetRow != null) {
            return targetRow;
        }
        if (this.lastCompareResult == 0) {
            targetRow = this.buildRow();
            this.initAggValuesAndMoveMap(null, true);
        } else if (this.lastCompareResult > 0) {
            targetRow = this.buildRow();
        } else {
            targetRow = this.makeTargetRow(this.lastMapKey, this.lastMapValue);
            this.initAggValuesAndMoveMap(null, true);
        }
        return targetRow;
    }

    private Row aggValue(boolean nextMapRow) {
        if (this.iter.hasNext()) {
            do {
                Row row;
                ArrayKey gk;
                if (!(gk = this.initGroupKey(row = this.iter.next())).equals(this.lastIterGroupKeys)) {
                    Row targetRow = this.makeTargetRow(this.lastIterGroupKeys, this.lastIterAggValues);
                    Object[] aggValues = this.initAggValuesAndMoveMap(gk, nextMapRow);
                    this.lastIterDistinctKey = null;
                    this.aggValue(aggValues, row);
                    this.lastIterGroupKeys = gk;
                    this.lastIterAggValues = aggValues;
                    return targetRow;
                }
                this.aggValue(this.lastIterAggValues, row);
            } while (this.iter.hasNext());
        }
        return null;
    }

    private Row buildRow() {
        Row targetRow = this.makeTargetRow(this.lastIterGroupKeys, this.lastIterAggValues);
        this.lastIterGroupKeys = null;
        this.lastIterAggValues = null;
        this.lastIterDistinctKey = null;
        return targetRow;
    }

    private Row makeTargetRow(ArrayKey groupKeys, Object[] aggValues) {
        return new GroupByRow(this.targetRowMeta, groupKeys, aggValues, this.aggregators);
    }
}

