/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.groupby.GroupByRow;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.ArrayKey;

class OrderBasedGroupByIterator
extends InnerRowIterator {
    private Iterator<Row> iter;
    protected Aggregator[] aggregators;
    protected boolean[] descs;
    protected RowMeta targetRowMeta;
    protected Calc[] groupCalcs;
    protected Calc[] aggCalcs;
    private Object[] firstIterAggValues = null;
    private ArrayKey firstIterGroupKeys = null;

    public OrderBasedGroupByIterator(Iterator<Row> iter, Calc[] groupCalcs, Calc[] aggCalcs, Aggregator[] aggregators, RowMeta targetRowMeta) {
        this.iter = iter;
        this.groupCalcs = groupCalcs;
        this.aggCalcs = aggCalcs;
        this.aggregators = aggregators;
        this.targetRowMeta = targetRowMeta;
        this.firstIter();
    }

    @Override
    public boolean _hasNext() {
        return this.firstIterGroupKeys != null;
    }

    @Override
    public Row _next() {
        return this.nextGroup();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final boolean firstIter() {
        if (!this.iter.hasNext()) {
            return false;
        }
        this.nextRow();
        return true;
    }

    private void nextRow() {
        Row row = this.iter.next();
        if (this.groupCalcs != null && this.groupCalcs.length > 0) {
            ArrayKey gk;
            Object[] keys = new Object[this.groupCalcs.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = this.groupCalcs[i].execute(row, null);
            }
            this.firstIterGroupKeys = gk = new ArrayKey(keys);
        } else {
            this.firstIterGroupKeys = ArrayKey.empty;
        }
        Object[] aggValues = new Object[this.aggregators.length];
        for (int i = 0; i < this.aggregators.length; ++i) {
            Object v = this.aggCalcs[i].execute(row, null);
            aggValues[i] = this.aggregators[i].appendValue(aggValues[i], v);
        }
        this.firstIterAggValues = aggValues;
    }

    public Row nextGroup() {
        if (!this._hasNext()) {
            return null;
        }
        if (this.iter.hasNext()) {
            do {
                ArrayKey gk;
                Row row = this.iter.next();
                if (this.groupCalcs != null && this.groupCalcs.length > 0) {
                    Object[] keys = new Object[this.groupCalcs.length];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = this.groupCalcs[i].execute(row, null);
                    }
                    gk = new ArrayKey(keys);
                } else {
                    gk = ArrayKey.empty;
                }
                if (!gk.equals(this.firstIterGroupKeys)) {
                    Row targetRow = this.makeTargetRow(this.firstIterGroupKeys, this.firstIterAggValues);
                    Object[] aggValues = new Object[this.aggregators.length];
                    for (int i = 0; i < this.aggregators.length; ++i) {
                        Object v = this.aggCalcs[i].execute(row, null);
                        aggValues[i] = this.aggregators[i].appendValue(aggValues[i], v);
                    }
                    this.firstIterGroupKeys = gk;
                    this.firstIterAggValues = aggValues;
                    return targetRow;
                }
                for (int i = 0; i < this.aggregators.length; ++i) {
                    Object v = this.aggCalcs[i].execute(row, null);
                    this.firstIterAggValues[i] = this.aggregators[i].appendValue(this.firstIterAggValues[i], v);
                }
            } while (this.iter.hasNext());
        }
        Row targetRow = this.makeTargetRow(this.firstIterGroupKeys, this.firstIterAggValues);
        this.firstIterGroupKeys = null;
        this.firstIterAggValues = null;
        return targetRow;
    }

    private Row makeTargetRow(ArrayKey groupKeys, Object[] aggValues) {
        return new GroupByRow(this.targetRowMeta, groupKeys, aggValues, this.aggregators);
    }
}

