/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.groupby.GroupByRow;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.ArrayKey;
import kd.bos.algo.util.Constants;

class OrderCountDistinctIterator
extends InnerRowIterator {
    private Iterator<Row> iter;
    private Aggregator[] aggregators;
    private RowMeta targetRowMeta;
    private Object[] lastIterAggValues = null;
    private ArrayKey lastIterGroupKeys = null;
    private String lastIterDistinctKey = null;
    private Calc[] groupCalcs;
    private Calc[] aggCalcs;
    private int aggLength;
    private int[] distinctFieldIndices;
    private boolean groupIsAllNulls;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public OrderCountDistinctIterator(Iterator<Row> iter, Calc[] groupCalcs, Calc[] aggCalcs, Aggregator[] aggregators, RowMeta targetRowMeta, int[] distinctFieldIndices, boolean groupIsAllNulls) {
        this.iter = iter;
        this.groupCalcs = groupCalcs;
        this.aggLength = aggregators.length;
        this.aggregators = aggregators;
        this.targetRowMeta = targetRowMeta;
        this.distinctFieldIndices = distinctFieldIndices;
        this.aggCalcs = aggCalcs;
        this.groupIsAllNulls = groupIsAllNulls;
        this.firstIter();
    }

    @Override
    public boolean _hasNext() {
        return this.lastIterGroupKeys != null;
    }

    @Override
    public Row _next() {
        if (this.lastIterGroupKeys != null) {
            return this.nextGroup();
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final void firstIter() {
        this.nextRow();
    }

    private void nextRow() {
        if (this.iter.hasNext()) {
            ArrayKey gk;
            Row row = this.iter.next();
            this.lastIterGroupKeys = gk = this.getGroupKey(row);
            Object[] aggValues = new Object[this.aggLength];
            this.aggValue(aggValues, row);
            this.lastIterAggValues = aggValues;
        }
    }

    private void aggValue(Object[] aggValues, Row row) {
        String countDistinctKey = this.getCountDistinctKey(row);
        for (int i = 0; i < this.aggLength; ++i) {
            String name = this.aggregators[i].name;
            Object value = "countdistinct".equalsIgnoreCase(name) ? (this.lastIterDistinctKey == null || !this.lastIterDistinctKey.equalsIgnoreCase(countDistinctKey) ? Constants.ONE_LONG : Constants.ZERO_LONG) : this.aggCalcs[i].execute(row, null);
            aggValues[i] = this.aggregators[i].appendValue(aggValues[i], value);
        }
        this.lastIterDistinctKey = countDistinctKey;
    }

    private ArrayKey getGroupKey(Row row) {
        ArrayKey gk;
        if (this.groupCalcs == null) {
            gk = new ArrayKey(new Object[0]);
        } else if (this.groupIsAllNulls) {
            gk = new ArrayKey(new Object[]{"null"});
        } else {
            Object[] keys = new Object[this.groupCalcs.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = this.groupCalcs[i].execute(row, null);
            }
            gk = new ArrayKey(keys);
        }
        return gk;
    }

    private String getCountDistinctKey(Row row) {
        StringBuilder builder = new StringBuilder();
        for (int index : this.distinctFieldIndices) {
            builder.append(this.getKey(row.get(index))).append("`");
        }
        return builder.toString();
    }

    private Object getKey(Object o) {
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).stripTrailingZeros().toPlainString();
        }
        if (o instanceof Date) {
            return this.sdf.format((Date)o);
        }
        if (o instanceof Timestamp) {
            return this.sdf.format((Timestamp)o);
        }
        return o;
    }

    public Row nextGroup() {
        if (!this._hasNext()) {
            return null;
        }
        while (this.iter.hasNext()) {
            Row row = this.iter.next();
            ArrayKey gk = this.getGroupKey(row);
            if (!gk.equals(this.lastIterGroupKeys)) {
                Row targetRow = this.makeTargetRow(this.lastIterGroupKeys, this.lastIterAggValues);
                Object[] aggValues = new Object[this.aggLength];
                this.lastIterDistinctKey = null;
                this.aggValue(aggValues, row);
                this.lastIterGroupKeys = gk;
                this.lastIterAggValues = aggValues;
                return targetRow;
            }
            this.aggValue(this.lastIterAggValues, row);
        }
        Row targetRow = this.makeTargetRow(this.lastIterGroupKeys, this.lastIterAggValues);
        this.lastIterGroupKeys = null;
        this.lastIterAggValues = null;
        this.lastIterDistinctKey = null;
        return targetRow;
    }

    private Row makeTargetRow(ArrayKey groupKeys, Object[] aggValues) {
        return new GroupByRow(this.targetRowMeta, groupKeys, aggValues, this.aggregators);
    }
}

