/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.groupby.GroupByRow;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.ArrayKey;

class OrderGrouperIterator
extends InnerRowIterator {
    private Iterator<Row> iter;
    protected Aggregator[] aggregators;
    protected boolean[] descs;
    protected RowMeta targetRowMeta;
    private Object[] firstIterAggValues = null;
    private ArrayKey firstIterGroupKeys = null;
    private int groupLength;
    private int aggLength;

    public OrderGrouperIterator(Iterator<Row> iter, int groupLength, Aggregator[] aggregators, RowMeta targetRowMeta) {
        this.iter = iter;
        this.groupLength = groupLength;
        this.aggLength = aggregators.length;
        this.aggregators = aggregators;
        this.targetRowMeta = targetRowMeta;
        this.firstIter();
    }

    @Override
    public boolean _hasNext() {
        return this.firstIterGroupKeys != null;
    }

    @Override
    public Row _next() {
        return this.nextGroup();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final boolean firstIter() {
        if (!this.iter.hasNext()) {
            return false;
        }
        this.nextRow();
        return true;
    }

    private void nextRow() {
        ArrayKey gk;
        Row row = this.iter.next();
        Object[] keys = new Object[this.groupLength];
        for (int i = 0; i < this.groupLength; ++i) {
            keys[i] = row.get(i);
        }
        this.firstIterGroupKeys = gk = new ArrayKey(keys);
        Object[] aggValues = new Object[this.aggLength];
        for (int i = 0; i < this.aggLength; ++i) {
            Object v = row.get(this.groupLength + i);
            aggValues[i] = this.aggregators[i].appendAggregator(aggValues[i], v);
        }
        this.firstIterAggValues = aggValues;
    }

    public Row nextGroup() {
        if (!this._hasNext()) {
            return null;
        }
        if (this.iter.hasNext()) {
            do {
                Row row = this.iter.next();
                Object[] keys = new Object[this.groupLength];
                for (int i = 0; i < this.groupLength; ++i) {
                    keys[i] = row.get(i);
                }
                ArrayKey gk = new ArrayKey(keys);
                if (!gk.equals(this.firstIterGroupKeys)) {
                    Row targetRow = this.makeTargetRow(this.firstIterGroupKeys, this.firstIterAggValues);
                    Object[] aggValues = new Object[this.aggLength];
                    for (int i = 0; i < this.aggLength; ++i) {
                        Object v = row.get(this.groupLength + i);
                        aggValues[i] = this.aggregators[i].appendAggregator(aggValues[i], v);
                    }
                    this.firstIterGroupKeys = gk;
                    this.firstIterAggValues = aggValues;
                    return targetRow;
                }
                for (int i = 0; i < this.aggLength; ++i) {
                    Object v = row.get(this.groupLength + i);
                    this.firstIterAggValues[i] = this.aggregators[i].appendAggregator(this.firstIterAggValues[i], v);
                }
            } while (this.iter.hasNext());
        }
        Row targetRow = this.makeTargetRow(this.firstIterGroupKeys, this.firstIterAggValues);
        this.firstIterGroupKeys = null;
        this.firstIterAggValues = null;
        return targetRow;
    }

    private Row makeTargetRow(ArrayKey groupKeys, Object[] aggValues) {
        return new GroupByRow(this.targetRowMeta, groupKeys, aggValues, this.aggregators);
    }
}

