/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.sql.tree.calc.Calc;

public class CrossJoinRow
extends AbstractRow {
    private AbstractRow leftRow;
    private AbstractRow rightRow;
    private int leftSize;
    private int rightSize;
    private RowMeta rowMeta;
    private Calc[] leftCalcs;
    private Calc[] rightCalcs;

    public CrossJoinRow(RowMeta rowMeta, Calc[] leftCalcs, Calc[] rightCalcs, AbstractRow leftRow, AbstractRow rightRow) {
        this.rowMeta = rowMeta;
        this.leftCalcs = leftCalcs;
        this.rightCalcs = rightCalcs;
        this.leftRow = leftRow;
        this.rightRow = rightRow;
        this.leftSize = leftCalcs.length;
        this.rightSize = rightCalcs.length;
    }

    @Override
    public int size() {
        return this.leftSize + this.rightSize;
    }

    @Override
    public Object get(int index) {
        if (index < this.leftSize) {
            return this.getLeft(index);
        }
        return this.getRight(index - this.leftSize);
    }

    private final Object getLeft(int index) {
        if (this.leftRow == null) {
            return null;
        }
        return this.leftCalcs[index].execute(this.leftRow, null);
    }

    private final Object getRight(int index) {
        if (this.rightRow == null) {
            return null;
        }
        return this.rightCalcs[index].execute(this.rightRow, null);
    }

    @Override
    public Object[] values() {
        return this.defaultConvertValues();
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

