/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import kd.bos.algo.JoinHint;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.join.AbstractJoinDataSet;
import kd.bos.algo.dataset.join.InnerNestJoinResult;
import kd.bos.algo.dataset.join.InnerOptimizeMergeJoinResult;
import kd.bos.algo.dataset.join.JoinDataSetBuilder;
import kd.bos.algo.dataset.join.JoinPolicy;
import kd.bos.algo.dataset.store.Store;

public class InnerJoinDataSet
extends AbstractJoinDataSet {
    private JoinHint joinHint;

    public InnerJoinDataSet(AbstractDataSet leftDataSet, AbstractDataSet rightDataSet, JoinDataSetBuilder builder) {
        super("InnerJoin", leftDataSet, rightDataSet, builder);
        this.joinHint = builder.getJoinHint();
    }

    @Override
    protected InnerRowIterator createIterator0() {
        this.checkClosed();
        AbstractDataSet leftDataSet = this.getLeftDataSet();
        AbstractDataSet rightDataSet = this.getRightDataSet();
        if (this.joinHint.isUseMerge()) {
            return new InnerOptimizeMergeJoinResult(leftDataSet.innerIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightDataSet.innerIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getSpanTag());
        }
        Store leftStore = leftDataSet.getStore();
        Store rightStore = rightDataSet.getStore();
        if (leftStore != null && rightStore != null) {
            int rightSize;
            int leftSize = leftStore.size();
            if (leftSize >= (rightSize = rightStore.size())) {
                if (this.joinHint.isUseNest() || JoinPolicy.shouldNestLoop(rightDataSet.getRowMeta(), rightSize)) {
                    return new InnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow);
                }
                return new InnerOptimizeMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getSpanTag());
            }
            if (this.joinHint.isUseNest() || JoinPolicy.shouldNestLoop(leftDataSet.getRowMeta(), leftSize)) {
                return new InnerNestJoinResult(rightStore.getRowIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX);
            }
            return new InnerOptimizeMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getSpanTag());
        }
        if (leftStore != null) {
            int leftSize = leftStore.size();
            if (this.joinHint.isUseNest() || JoinPolicy.shouldNestLoop(leftDataSet.getRowMeta(), leftSize)) {
                return new InnerNestJoinResult(rightDataSet.innerIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX);
            }
            rightDataSet.ensureStore();
            rightStore = rightDataSet.getStore();
            int rightSize = rightStore.size();
            if (JoinPolicy.shouldNestLoop(rightDataSet.getRowMeta(), rightSize)) {
                return new InnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow);
            }
            if (leftSize > rightSize) {
                return new InnerOptimizeMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getSpanTag());
            }
            return new InnerOptimizeMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getSpanTag());
        }
        if (rightStore == null) {
            rightDataSet.ensureStore();
            rightStore = rightDataSet.getStore();
        }
        int rightSize = rightStore.size();
        if (JoinPolicy.shouldNestLoop(rightDataSet.getRowMeta(), rightSize)) {
            return new InnerNestJoinResult(leftDataSet.innerIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow);
        }
        leftDataSet.ensureStore();
        leftStore = leftDataSet.getStore();
        int leftSize = leftStore.size();
        if (JoinPolicy.shouldNestLoop(leftDataSet.getRowMeta(), leftSize)) {
            return new InnerNestJoinResult(rightStore.getRowIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX);
        }
        if (leftSize > rightSize) {
            return new InnerOptimizeMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getSpanTag());
        }
        return new InnerOptimizeMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getSpanTag());
    }
}

