/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.join.NestInnerIndex;
import kd.bos.algo.dataset.join.RowMakeFunc;
import kd.bos.algo.dataset.store.Store;

public class InnerNestJoinResult
extends InnerRowIterator {
    private Iterator<Row> outterIter;
    private Store innerStore;
    private RowMakeFunc makeFunc;
    private boolean inited;
    private final Object[] keys;
    private final int keyLen;
    private boolean empty = false;
    private Iterator<Row> innerIter;
    private NestInnerIndex innerIndex;
    private Row outterRow;
    private int[] outterJoinOnColumns;
    private int[] innerJoinOnColumns;
    private boolean closed;

    public InnerNestJoinResult(Iterator<Row> outterIter, int[] outterJoinOnColumns, Store innerStore, RowMeta innerRowMeta, int[] innerJoinOnColumns, RowMakeFunc makeFunc) {
        this.outterIter = outterIter;
        this.outterJoinOnColumns = outterJoinOnColumns;
        this.innerStore = innerStore;
        this.innerJoinOnColumns = innerJoinOnColumns;
        this.makeFunc = makeFunc;
        this.keyLen = outterJoinOnColumns.length;
        this.keys = new Object[this.keyLen];
    }

    private void init() {
        this.inited = true;
        if (this.outterIter.hasNext() && this.innerStore.size() > 0) {
            this.buildIndex();
        } else {
            this.empty = true;
        }
    }

    private void buildIndex() {
        this.innerIndex = new NestInnerIndex(this.innerJoinOnColumns);
        this.innerIndex.build(this.innerStore);
    }

    @Override
    public boolean _hasNext() {
        if (!this.inited) {
            this.init();
        }
        if (this.empty) {
            return false;
        }
        if (this.innerIter != null && this.innerIter.hasNext()) {
            return true;
        }
        this.innerIter = this.getInnerIter();
        return this.innerIter != null;
    }

    private Iterator<Row> getInnerIter() {
        while (this.outterIter.hasNext()) {
            this.outterRow = this.outterIter.next();
            for (int i = 0; i < this.outterJoinOnColumns.length; ++i) {
                this.keys[i] = this.outterRow.get(this.outterJoinOnColumns[i]);
            }
            Iterator<Row> ret = this.innerIndex.get(this.keyLen == 1 ? this.keys[0] : this.keys);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public Row _next() {
        Row row = this.innerIter.next();
        return this.makeFunc.make(this.outterRow, row);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.innerIndex != null) {
                this.innerIndex.close();
            }
            this.closed = true;
        }
    }
}

