/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.join.RowMakeFunc;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.util.AlgoUtil;

public class InnerOptimizeMergeJoinResult
extends InnerRowIterator {
    private Iterator<Row> outterIter;
    private Iterator<Row> innerIter;
    private Store outterOrderStore;
    private Store innerOrderStore;
    private RowMeta innerRowMeta;
    private int[] innerJoinOnColumns;
    private RowMakeFunc makeFunc;
    private int[] outterJoinOnColumns;
    private RowMeta outterRowMeta;
    private String spanTag;
    private OrderItem[] outterOrderItems;
    private OrderItem[] innerOrderItems;
    private boolean eof;
    private Iterator<Row> innerStoreIterator;
    private boolean stillWrite;
    private Store innerStore;
    private boolean rowEquals;
    private Row outterRow;
    private Row innerRow;
    private Row lastInnerRow;
    private boolean closed;

    public InnerOptimizeMergeJoinResult(Iterator<Row> outterIter, RowMeta outterRowMeta, OrderItem[] outterOrderItems, int[] outterJoinOnColumns, Iterator<Row> innerIter, RowMeta innerRowMeta, OrderItem[] innerOrderItems, int[] innerJoinOnColumns, RowMakeFunc makeFunc, String spanTag) {
        this.outterIter = outterIter;
        this.innerIter = innerIter;
        this.outterRowMeta = outterRowMeta;
        this.outterOrderItems = outterOrderItems;
        this.outterJoinOnColumns = outterJoinOnColumns;
        this.innerRowMeta = innerRowMeta;
        this.innerOrderItems = innerOrderItems;
        this.innerJoinOnColumns = innerJoinOnColumns;
        this.makeFunc = makeFunc;
        this.spanTag = spanTag;
        assert (outterJoinOnColumns.length == innerJoinOnColumns.length);
        this.init();
    }

    private void init() {
        boolean bl = this.eof = !this.outterIter.hasNext() || !this.innerIter.hasNext();
        if (this.eof) {
            return;
        }
        this.outterOrderStore = StoreFactory.createOrderStore(this.outterRowMeta, this.outterOrderItems);
        this.outterOrderStore.write(this.outterIter);
        this.outterIter = this.outterOrderStore.getRowIterator();
        this.innerOrderStore = StoreFactory.createOrderStore(this.innerRowMeta, this.innerOrderItems);
        this.innerOrderStore.write(this.innerIter);
        this.innerIter = this.innerOrderStore.getRowIterator();
        this.initFirst();
    }

    private void initFirst() {
        if (!this.outterIter.hasNext()) {
            this.eof = true;
            return;
        }
        this.outterRow = this.outterIter.next();
        if (!this.innerIter.hasNext()) {
            this.eof = true;
            return;
        }
        this.innerRow = this.innerIter.next();
    }

    @Override
    public boolean _hasNext() {
        if (this.eof) {
            this.close();
            return false;
        }
        this.move();
        if (!this.rowEquals) {
            this.close();
        }
        return this.rowEquals;
    }

    @Override
    public Row _next() {
        Row returnRow = this.makeFunc.make(this.outterRow, this.innerRow);
        this.mergeEqualRow();
        return returnRow;
    }

    private void mergeEqualRow() {
        if (this.innerStore != null) {
            if (this.stillWrite) {
                this.stillWriteInnerStore();
            } else {
                this.innerStoreNextRow();
            }
        } else {
            this.initInnerStore();
        }
    }

    private void move() {
        block5: {
            while (true) {
                if (this.innerRow == null || this.outterRow == null) {
                    this.eof = true;
                    this.rowEquals = false;
                    break block5;
                }
                int compareResult = this.compare(this.outterRow, this.innerRow);
                if (compareResult > 0) {
                    this.rowEquals = false;
                    if (this.innerStore != null && this.innerStoreIterator != null) {
                        this.closeInnerStore();
                        continue;
                    }
                    this.nextInnerRow();
                    continue;
                }
                if (compareResult >= 0) break;
                this.rowEquals = false;
                if (this.innerStore != null && this.innerStoreIterator == null) {
                    this.lessThanZeroHandleInnerStore();
                    continue;
                }
                this.nextOutterRow();
            }
            this.rowEquals = true;
        }
    }

    private void closeInnerStore() {
        this.innerStore.close();
        this.innerStoreIterator = null;
        this.innerStore = null;
        this.stillWrite = false;
        this.innerRow = this.lastInnerRow;
        this.lastInnerRow = null;
    }

    private void nextInnerRow() {
        this.innerRow = this.innerIter.hasNext() ? this.innerIter.next() : null;
    }

    private void nextOutterRow() {
        this.outterRow = this.outterIter.hasNext() ? this.outterIter.next() : null;
    }

    private void lessThanZeroHandleInnerStore() {
        this.stillWrite = false;
        this.lastInnerRow = this.innerRow;
        if (this.outterIter.hasNext()) {
            this.outterRow = this.outterIter.next();
            this.innerStoreIterator = this.innerStore.getRowIterator();
            this.innerRow = this.innerStoreIterator.next();
        } else {
            this.outterRow = null;
            this.innerStore.close();
            this.innerStore = null;
            this.innerStoreIterator = null;
            this.stillWrite = false;
        }
    }

    private void createInnerStore() {
        if (this.innerStore != null) {
            this.innerStore.close();
        }
        this.innerStore = StoreFactory.createMergeJoinBufferStore(this.innerRowMeta);
    }

    private void initInnerStore() {
        this.createInnerStore();
        this.innerStore.write(this.innerRow);
        this.stillWrite = true;
        if (this.innerIter.hasNext()) {
            this.innerRow = this.innerIter.next();
            int compareResult = this.compare(this.outterRow, this.innerRow);
            if (compareResult == 0) {
                this.innerStore.write(this.innerRow);
            } else {
                this.lastInnerRow = this.innerRow;
                this.stillWrite = false;
                this.innerStoreIterator = this.innerStore.getRowIterator();
                this.innerRow = this.innerStoreIterator.next();
                this.nextOutterRow();
            }
        } else if (this.outterIter.hasNext()) {
            this.stillWrite = false;
            this.innerStoreIterator = this.innerStore.getRowIterator();
            this.innerRow = this.innerStoreIterator.next();
            this.outterRow = this.outterIter.next();
        } else {
            this.outterRow = null;
            this.innerRow = null;
        }
    }

    private void innerStoreNextRow() {
        if (this.innerStoreIterator.hasNext()) {
            this.innerRow = this.innerStoreIterator.next();
        } else if (this.outterIter.hasNext()) {
            this.compareOutterRowAndInnerStoreRow(false);
        } else {
            this.outterRow = null;
            this.innerRow = this.lastInnerRow;
        }
    }

    private void stillWriteInnerStore() {
        if (this.innerIter.hasNext()) {
            this.innerRow = this.innerIter.next();
            int compareResult = this.compare(this.outterRow, this.innerRow);
            if (compareResult == 0) {
                this.innerStore.write(this.innerRow);
            } else {
                this.lastInnerRow = this.innerRow;
                this.stillWrite = false;
                this.innerStoreIterator = this.innerStore.getRowIterator();
                this.innerRow = this.innerStoreIterator.next();
                this.nextOutterRow();
            }
        } else if (this.outterIter.hasNext()) {
            this.compareOutterRowAndInnerStoreRow(true);
        } else {
            this.outterRow = null;
            this.innerRow = null;
        }
    }

    private void compareOutterRowAndInnerStoreRow(boolean setInnerRowNull) {
        this.stillWrite = false;
        this.innerStoreIterator = this.innerStore.getRowIterator();
        this.innerRow = this.innerStoreIterator.next();
        this.outterRow = this.outterIter.next();
        int compareResult = this.compare(this.outterRow, this.innerRow);
        if (compareResult != 0) {
            this.innerRow = setInnerRowNull ? null : this.lastInnerRow;
            this.innerStore.close();
            this.innerStore = null;
            this.innerStoreIterator = null;
            this.stillWrite = false;
            this.lastInnerRow = null;
        }
    }

    private int compare(Row outterRow, Row innerRow) {
        for (int i = 0; i < this.outterJoinOnColumns.length; ++i) {
            Object o2;
            Object o1 = outterRow.get(this.outterJoinOnColumns[i]);
            int r = AlgoUtil.compareValue(o1, o2 = innerRow.get(this.innerJoinOnColumns[i]));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.innerStore != null) {
                this.innerStore.close();
            }
            if (this.outterOrderStore != null) {
                this.outterOrderStore.close();
            }
            if (this.innerOrderStore != null) {
                this.innerOrderStore.close();
            }
            this.closed = true;
        }
    }
}

