/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.join.AbstractJoinDataSet;
import kd.bos.algo.dataset.join.JoinDataSetBuilder;
import kd.bos.algo.dataset.join.JoinPolicy;
import kd.bos.algo.dataset.join.NotInnerNestJoinResult;
import kd.bos.algo.dataset.join.NotInnerOptimizeMergeJoinResult;
import kd.bos.algo.dataset.join.NotInnerType;
import kd.bos.algo.dataset.store.Store;

public class NotInnerJoinDataSet
extends AbstractJoinDataSet {
    private JoinType joinType;
    private JoinHint joinHint;
    private boolean eanbleOpt = AlgoConfiguration.JOIN_OPT_ENABLE.getBoolean();

    public NotInnerJoinDataSet(AbstractDataSet leftDataSet, AbstractDataSet rightDataSet, JoinDataSetBuilder builder) {
        super(builder.getJoinType().getName(), leftDataSet, rightDataSet, builder);
        this.joinType = builder.getJoinType();
        this.joinHint = builder.getJoinHint();
    }

    private NotInnerType getNotInnerType(boolean x) {
        if (JoinType.FULL == this.joinType) {
            return NotInnerType.Both;
        }
        if (JoinType.RIGHT == this.joinType && x || JoinType.RIGHT != this.joinType && !x) {
            return NotInnerType.Outter;
        }
        return NotInnerType.Inner;
    }

    @Override
    protected InnerRowIterator createIterator0() {
        this.checkClosed();
        AbstractDataSet leftDataSet = this.getLeftDataSet();
        AbstractDataSet rightDataSet = this.getRightDataSet();
        if (this.joinHint.isUseMerge()) {
            return new NotInnerOptimizeMergeJoinResult(leftDataSet.innerIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightDataSet.innerIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false), this.getSpanTag());
        }
        Store leftStore = leftDataSet.getStore();
        Store rightStore = rightDataSet.getStore();
        if (leftStore != null && rightStore != null) {
            int rightSize;
            int leftSize = leftStore.size();
            if (leftSize >= (rightSize = rightStore.size())) {
                if (this.joinHint.isUseNest() || JoinPolicy.shouldNestLoop(rightDataSet.getRowMeta(), rightSize)) {
                    return new NotInnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
                }
                return new NotInnerOptimizeMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false), this.getSpanTag());
            }
            if (this.joinHint.isUseMerge() || this.eanbleOpt) {
                return new NotInnerOptimizeMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true), this.getSpanTag());
            }
            if (this.joinHint.isUseNest() || JoinPolicy.shouldNestLoop(leftDataSet.getRowMeta(), leftSize)) {
                return new NotInnerNestJoinResult(rightStore.getRowIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
            }
            return new NotInnerOptimizeMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true), this.getSpanTag());
        }
        if (leftStore != null) {
            int leftSize = leftStore.size();
            if (JoinPolicy.shouldNestLoop(leftDataSet.getRowMeta(), leftSize)) {
                return new NotInnerNestJoinResult(rightDataSet.innerIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
            }
            rightDataSet.ensureStore();
            rightStore = rightDataSet.getStore();
            int rightSize = rightStore.size();
            if (JoinPolicy.shouldNestLoop(rightDataSet.getRowMeta(), rightSize)) {
                return new NotInnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
            }
            if (this.joinHint.isUseNest()) {
                if (leftSize > rightSize) {
                    return new NotInnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
                }
                return new NotInnerNestJoinResult(rightDataSet.innerIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
            }
            if (leftSize > rightSize) {
                return new NotInnerOptimizeMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false), this.getSpanTag());
            }
            return new NotInnerOptimizeMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true), this.getSpanTag());
        }
        if (rightStore == null) {
            rightDataSet.ensureStore();
            rightStore = rightDataSet.getStore();
        }
        int rightSize = rightStore.size();
        if (JoinPolicy.shouldNestLoop(rightDataSet.getRowMeta(), rightSize)) {
            return new NotInnerNestJoinResult(leftDataSet.innerIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
        }
        leftDataSet.ensureStore();
        leftStore = leftDataSet.getStore();
        int leftSize = leftStore.size();
        if (JoinPolicy.shouldNestLoop(leftDataSet.getRowMeta(), leftSize)) {
            return new NotInnerNestJoinResult(rightStore.getRowIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
        }
        if (this.joinHint.isUseNest()) {
            if (leftSize > rightSize) {
                return new NotInnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false));
            }
            return new NotInnerNestJoinResult(rightDataSet.innerIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true));
        }
        if (leftSize > rightSize) {
            return new NotInnerOptimizeMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getNotInnerType(false), this.getSpanTag());
        }
        return new NotInnerOptimizeMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getNotInnerType(true), this.getSpanTag());
    }
}

