/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.join.NotInnerType;
import kd.bos.algo.dataset.join.RowMakeFunc;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.util.AlgoUtil;

public class NotInnerMergeJoinResult
extends InnerRowIterator {
    private Store outterOrderStore;
    private Store innerOrderStore;
    private Iterator<Row> outterIter;
    private Iterator<Row> innerIter;
    private RowMeta innerRowMeta;
    private int[] innerJoinOnColumns;
    private RowMakeFunc makeFunc;
    private int[] outterJoinOnColumns;
    private RowMeta outterRowMeta;
    private NotInnerType nit;
    private OrderItem[] outterOrderItems;
    private OrderItem[] innerOrderItems;
    private boolean inited;
    private boolean eof;
    private Iterator<Row> innerRemainIterator = null;
    private Iterator<Row> outterRemainIterator = null;
    private boolean firstMove = true;
    private Row outterRow;
    private Row innerRow;
    private Box box;
    private Store outterBoxStore = null;
    private Store innerBoxStore = null;
    private boolean closed;

    public NotInnerMergeJoinResult(Iterator<Row> outterIter, RowMeta outterRowMeta, OrderItem[] outterOrderItems, int[] outterJoinOnColumns, Iterator<Row> innerIter, RowMeta innerRowMeta, OrderItem[] innerOrderItems, int[] innerJoinOnColumns, RowMakeFunc makeFunc, NotInnerType nit, String spanTag) {
        this.outterIter = outterIter;
        this.outterRowMeta = outterRowMeta;
        this.outterOrderItems = outterOrderItems;
        this.outterJoinOnColumns = outterJoinOnColumns;
        this.innerIter = innerIter;
        this.innerRowMeta = innerRowMeta;
        this.innerOrderItems = innerOrderItems;
        this.innerJoinOnColumns = innerJoinOnColumns;
        this.makeFunc = makeFunc;
        this.nit = nit;
        assert (outterJoinOnColumns.length == innerJoinOnColumns.length);
    }

    private void init() {
        boolean innerIsEmpty;
        this.inited = true;
        boolean outterIsEmpty = !this.outterIter.hasNext();
        boolean bl = innerIsEmpty = !this.innerIter.hasNext();
        if (outterIsEmpty && innerIsEmpty) {
            this.eof = true;
            return;
        }
        if (outterIsEmpty) {
            if (NotInnerType.Outter == this.nit) {
                this.eof = true;
            } else {
                this.initInner();
                this.innerRemainIterator = this.makeInnerRemainIterator(null);
            }
            return;
        }
        if (innerIsEmpty) {
            if (NotInnerType.Inner == this.nit) {
                this.eof = true;
            } else {
                this.initOutter();
                this.outterRemainIterator = this.makeOutterRemainIterator(null);
            }
            return;
        }
        this.initOutter();
        this.initInner();
    }

    private Iterator<Row> makeOutterRemainIterator(Row lastRow) {
        final Iterator remainIter = lastRow != null ? Iterators.concat((Iterator)Iterators.singletonIterator((Object)lastRow), this.outterIter) : this.outterIter;
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                boolean b = remainIter.hasNext();
                if (!b) {
                    NotInnerMergeJoinResult.this.eof = true;
                }
                return b;
            }

            @Override
            public Row next() {
                return NotInnerMergeJoinResult.this.makeFunc.make((Row)remainIter.next(), null);
            }
        };
    }

    private Iterator<Row> makeInnerRemainIterator(Row lastRow) {
        final Iterator remainIter = lastRow != null ? Iterators.concat((Iterator)Iterators.singletonIterator((Object)lastRow), this.innerIter) : this.innerIter;
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                boolean b = remainIter.hasNext();
                if (!b) {
                    NotInnerMergeJoinResult.this.eof = true;
                }
                return b;
            }

            @Override
            public Row next() {
                return NotInnerMergeJoinResult.this.makeFunc.make(null, (Row)remainIter.next());
            }
        };
    }

    private void initOutter() {
        this.outterOrderStore = StoreFactory.createOrderStore(this.outterRowMeta, this.outterOrderItems);
        this.outterOrderStore.write(this.outterIter);
        this.outterIter = this.outterOrderStore.getRowIterator();
    }

    private void initInner() {
        this.innerOrderStore = StoreFactory.createOrderStore(this.innerRowMeta, this.innerOrderItems);
        this.innerOrderStore.write(this.innerIter);
        this.innerIter = this.innerOrderStore.getRowIterator();
    }

    @Override
    public boolean _hasNext() {
        if (this.eof) {
            return false;
        }
        if (!this.inited) {
            this.init();
        }
        if (this.box != null) {
            if (this.box.hasNext()) {
                return true;
            }
            this.box.close();
            this.box = null;
        } else if (this.outterRemainIterator != null) {
            if (this.outterRemainIterator.hasNext()) {
                return true;
            }
            this.outterRemainIterator = null;
        } else if (this.innerRemainIterator != null) {
            if (this.innerRemainIterator.hasNext()) {
                return true;
            }
            this.innerRemainIterator = null;
        }
        this.box = null;
        this.move();
        return this.box != null || this.outterRemainIterator != null || this.innerRemainIterator != null;
    }

    @Override
    public Row _next() {
        if (this.box != null) {
            return this.box.next();
        }
        if (this.outterRemainIterator != null) {
            return this.outterRemainIterator.next();
        }
        return this.innerRemainIterator.next();
    }

    private void move() {
        block19: {
            Row innerBeginRow;
            block18: {
                Row outterBeginRow;
                if (this.eof) {
                    return;
                }
                if (this.firstMove) {
                    if (this.outterIter.hasNext()) {
                        this.outterRow = this.outterIter.next();
                    }
                    if (this.innerIter.hasNext()) {
                        this.innerRow = this.innerIter.next();
                    }
                    this.firstMove = false;
                }
                while (true) {
                    if (this.outterRow == null) {
                        if (NotInnerType.Outter != this.nit && this.innerRow != null) {
                            this.innerRemainIterator = this.makeInnerRemainIterator(this.innerRow);
                        } else {
                            this.eof = true;
                        }
                        return;
                    }
                    if (this.innerRow == null) {
                        if (NotInnerType.Inner != this.nit && this.outterRow != null) {
                            this.outterRemainIterator = this.makeOutterRemainIterator(this.outterRow);
                        } else {
                            this.eof = true;
                        }
                        return;
                    }
                    int c = this.compare(this.outterRow, this.innerRow);
                    if (c < 0) {
                        outterBeginRow = this.outterRow;
                        this.outterRow = null;
                        if (NotInnerType.Inner != this.nit) {
                            this.outterRemainIterator = new Iterator<Row>(){
                                private Row firstRow;
                                private Row row;
                                {
                                    this.firstRow = outterBeginRow;
                                    this.row = outterBeginRow;
                                }

                                @Override
                                public boolean hasNext() {
                                    if (this.row != null) {
                                        return true;
                                    }
                                    if (NotInnerMergeJoinResult.this.outterIter.hasNext()) {
                                        NotInnerMergeJoinResult.this.outterRow = (Row)NotInnerMergeJoinResult.this.outterIter.next();
                                        if (NotInnerMergeJoinResult.this.equalsOutter(this.firstRow, NotInnerMergeJoinResult.this.outterRow)) {
                                            this.row = NotInnerMergeJoinResult.this.outterRow;
                                            return true;
                                        }
                                    } else {
                                        NotInnerMergeJoinResult.this.outterRow = null;
                                    }
                                    return false;
                                }

                                @Override
                                public Row next() {
                                    if (this.row != null) {
                                        Row ret = NotInnerMergeJoinResult.this.makeFunc.make(this.row, null);
                                        this.row = null;
                                        return ret;
                                    }
                                    throw new NoSuchElementException();
                                }
                            };
                            return;
                        }
                        if (!this.outterIter.hasNext()) continue;
                        this.outterRow = this.outterIter.next();
                        continue;
                    }
                    if (c <= 0) break;
                    final Row innerBeginRow2 = this.innerRow;
                    this.innerRow = null;
                    if (NotInnerType.Outter != this.nit) {
                        this.innerRemainIterator = new Iterator<Row>(){
                            private Row firstRow;
                            private Row row;
                            {
                                this.firstRow = innerBeginRow2;
                                this.row = innerBeginRow2;
                            }

                            @Override
                            public boolean hasNext() {
                                if (this.row != null) {
                                    return true;
                                }
                                if (NotInnerMergeJoinResult.this.innerIter.hasNext()) {
                                    NotInnerMergeJoinResult.this.innerRow = (Row)NotInnerMergeJoinResult.this.innerIter.next();
                                    if (NotInnerMergeJoinResult.this.equalsInner(this.firstRow, NotInnerMergeJoinResult.this.innerRow)) {
                                        this.row = NotInnerMergeJoinResult.this.innerRow;
                                        return true;
                                    }
                                } else {
                                    NotInnerMergeJoinResult.this.innerRow = null;
                                }
                                return false;
                            }

                            @Override
                            public Row next() {
                                if (this.row != null) {
                                    Row ret = NotInnerMergeJoinResult.this.makeFunc.make(null, this.row);
                                    this.row = null;
                                    return ret;
                                }
                                throw new NoSuchElementException();
                            }
                        };
                        return;
                    }
                    if (!this.innerIter.hasNext()) continue;
                    this.innerRow = this.innerIter.next();
                }
                outterBeginRow = this.outterRow;
                innerBeginRow = this.innerRow;
                this.outterRow = null;
                this.innerRow = null;
                this.createInnerBoxStore();
                this.createOutterBoxStore();
                this.outterBoxStore.write(outterBeginRow);
                this.innerBoxStore.write(innerBeginRow);
                while (this.outterIter.hasNext()) {
                    this.outterRow = this.outterIter.next();
                    if (this.equalsOutter(outterBeginRow, this.outterRow)) {
                        this.outterBoxStore.write(this.outterRow);
                        continue;
                    }
                    break block18;
                }
                this.outterRow = null;
            }
            while (this.innerIter.hasNext()) {
                this.innerRow = this.innerIter.next();
                if (this.equalsInner(innerBeginRow, this.innerRow)) {
                    this.innerBoxStore.write(this.innerRow);
                    continue;
                }
                break block19;
            }
            this.innerRow = null;
        }
        this.box = new Box(this.outterBoxStore, this.innerBoxStore);
    }

    private void createOutterBoxStore() {
        if (this.outterBoxStore != null) {
            this.outterBoxStore.close();
        }
        this.outterBoxStore = StoreFactory.createMergeJoinBufferStore(this.outterRowMeta);
    }

    private void createInnerBoxStore() {
        if (this.innerBoxStore != null) {
            this.innerBoxStore.close();
        }
        this.innerBoxStore = StoreFactory.createMergeJoinBufferStore(this.innerRowMeta);
    }

    private boolean equalsInner(Row innerBeginRow, Row row2) {
        for (int i = 0; i < this.innerJoinOnColumns.length; ++i) {
            Object o2;
            int column = this.innerJoinOnColumns[i];
            Object o1 = innerBeginRow.get(column);
            if (AlgoUtil.equal(o1, o2 = row2.get(column))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsOutter(Row outterBeginRow, Row row2) {
        for (int i = 0; i < this.outterJoinOnColumns.length; ++i) {
            Object o2;
            int column = this.outterJoinOnColumns[i];
            Object o1 = outterBeginRow.get(column);
            if (AlgoUtil.equal(o1, o2 = row2.get(column))) continue;
            return false;
        }
        return true;
    }

    private int compare(Row outterRow, Row innerRow) {
        for (int i = 0; i < this.outterJoinOnColumns.length; ++i) {
            Object o2;
            Object o1 = outterRow.get(this.outterJoinOnColumns[i]);
            int r = AlgoUtil.compareValue(o1, o2 = innerRow.get(this.innerJoinOnColumns[i]));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.box != null) {
                this.box.close();
            }
            if (this.outterOrderStore != null) {
                this.outterOrderStore.close();
            }
            if (this.innerOrderStore != null) {
                this.innerOrderStore.close();
            }
            this.closed = true;
        }
    }

    class Box
    implements Iterator<Row> {
        private Iterator<Row> outterIter;
        private Iterator<Row> innerIter;
        private Row outterRow;
        private Row innerRow;
        private Store innerBoxStore;
        private Store outterBoxStore;
        private boolean closed;

        public Box(Store outterBoxStore, Store innerBoxStore) {
            this.outterBoxStore = outterBoxStore;
            this.innerBoxStore = innerBoxStore;
            this.outterIter = outterBoxStore.getRowIterator();
            this.innerIter = innerBoxStore.getRowIterator();
        }

        @Override
        public boolean hasNext() {
            return this.outterIter.hasNext() || this.innerIter.hasNext();
        }

        @Override
        public Row next() {
            if (!this.innerIter.hasNext()) {
                this.innerIter = this.innerBoxStore.getRowIterator();
                this.innerRow = this.innerIter.next();
                this.outterRow = this.outterIter.next();
            } else {
                if (this.outterRow == null) {
                    this.outterRow = this.outterIter.next();
                }
                this.innerRow = this.innerIter.next();
            }
            return NotInnerMergeJoinResult.this.makeFunc.make(this.outterRow, this.innerRow);
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                try {
                    this.outterBoxStore.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.innerBoxStore.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

