/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.join.NotInnerType;
import kd.bos.algo.dataset.join.RowMakeFunc;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.util.AlgoUtil;

public class NotInnerOptimizeMergeJoinResult
extends InnerRowIterator {
    private Store outterOrderStore;
    private Store innerOrderStore;
    private Iterator<Row> outterIter;
    private Iterator<Row> innerIter;
    private RowMeta innerRowMeta;
    private int[] innerJoinOnColumns;
    private RowMakeFunc makeFunc;
    private int[] outterJoinOnColumns;
    private RowMeta outterRowMeta;
    private NotInnerType nit;
    private OrderItem[] outterOrderItems;
    private OrderItem[] innerOrderItems;
    private boolean eof;
    private Iterator<Row> innerStoreIterator;
    private boolean stillWrite;
    private Store innerStore;
    private Row outterRow;
    private Row innerRow;
    private Row lastInnerRow;
    private boolean closed;

    public NotInnerOptimizeMergeJoinResult(Iterator<Row> outterIter, RowMeta outterRowMeta, OrderItem[] outterOrderItems, int[] outterJoinOnColumns, Iterator<Row> innerIter, RowMeta innerRowMeta, OrderItem[] innerOrderItems, int[] innerJoinOnColumns, RowMakeFunc makeFunc, NotInnerType nit, String spanTag) {
        this.outterIter = outterIter;
        this.outterRowMeta = outterRowMeta;
        this.outterOrderItems = outterOrderItems;
        this.outterJoinOnColumns = outterJoinOnColumns;
        this.innerIter = innerIter;
        this.innerRowMeta = innerRowMeta;
        this.innerOrderItems = innerOrderItems;
        this.innerJoinOnColumns = innerJoinOnColumns;
        this.makeFunc = makeFunc;
        this.nit = nit;
        assert (outterJoinOnColumns.length == innerJoinOnColumns.length);
        this.init();
    }

    @Override
    public boolean _hasNext() {
        boolean result;
        if (this.eof) {
            return false;
        }
        if (this.outterRow == null && NotInnerType.Outter == this.nit) {
            return false;
        }
        if (this.innerRow == null && NotInnerType.Inner == this.nit) {
            return false;
        }
        boolean bl = result = this.outterRow != null || this.innerRow != null;
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public Row _next() {
        while (true) {
            if (this.outterRow == null) {
                if (this.innerStore != null && this.innerStoreIterator != null) {
                    this.closeInnerStore();
                }
                Row returnRow = this.makeFunc.make(null, this.innerRow);
                this.nextInnerRow();
                return returnRow;
            }
            if (this.innerRow == null) {
                Row returnRow = this.makeFunc.make(this.outterRow, null);
                this.nextOutterRow();
                return returnRow;
            }
            int compareResult = this.compare(this.outterRow, this.innerRow);
            if (compareResult > 0) {
                if (this.innerStore != null && this.innerStoreIterator != null) {
                    this.closeInnerStore();
                    continue;
                }
                if (NotInnerType.Outter != this.nit) {
                    Row returnRow = this.makeFunc.make(null, this.innerRow);
                    this.nextInnerRow();
                    return returnRow;
                }
                this.nextInnerRow();
                continue;
            }
            if (compareResult >= 0) break;
            if (this.innerStore != null && this.innerStoreIterator == null) {
                this.lessThanZeroHandleInnerStore();
                continue;
            }
            if (NotInnerType.Inner != this.nit) {
                Row returnRow = this.makeFunc.make(this.outterRow, null);
                this.nextOutterRow();
                return returnRow;
            }
            this.nextOutterRow();
        }
        Row returnRow = this.makeFunc.make(this.outterRow, this.innerRow);
        if (this.innerStore != null) {
            if (this.stillWrite) {
                this.stillWriteInnerStore();
            } else {
                this.innerStoreNextRow();
            }
        } else {
            this.initInnerStore();
        }
        return returnRow;
    }

    private void closeInnerStore() {
        this.innerStore.close();
        this.innerStoreIterator = null;
        this.innerStore = null;
        this.stillWrite = false;
        this.innerRow = this.lastInnerRow;
        this.lastInnerRow = null;
    }

    private void nextInnerRow() {
        this.innerRow = this.innerIter.hasNext() ? this.innerIter.next() : null;
    }

    private void nextOutterRow() {
        this.outterRow = this.outterIter.hasNext() ? this.outterIter.next() : null;
    }

    private void lessThanZeroHandleInnerStore() {
        this.stillWrite = false;
        this.lastInnerRow = this.innerRow;
        if (this.outterIter.hasNext()) {
            this.outterRow = this.outterIter.next();
            this.innerStoreIterator = this.innerStore.getRowIterator();
            this.innerRow = this.innerStoreIterator.next();
        } else {
            this.outterRow = null;
            this.innerStore.close();
            this.innerStore = null;
            this.innerStoreIterator = null;
            this.stillWrite = false;
        }
    }

    private void createInnerStore() {
        if (this.innerStore != null) {
            this.innerStore.close();
        }
        this.innerStore = StoreFactory.createMergeJoinBufferStore(this.innerRowMeta);
    }

    private void initInnerStore() {
        this.createInnerStore();
        this.innerStore.write(this.innerRow);
        this.stillWrite = true;
        if (this.innerIter.hasNext()) {
            this.innerRow = this.innerIter.next();
            int compareResult = this.compare(this.outterRow, this.innerRow);
            if (compareResult == 0) {
                this.innerStore.write(this.innerRow);
            } else {
                this.lastInnerRow = this.innerRow;
                this.stillWrite = false;
                this.innerStoreIterator = this.innerStore.getRowIterator();
                this.innerRow = this.innerStoreIterator.next();
                this.nextOutterRow();
            }
        } else if (this.outterIter.hasNext()) {
            this.stillWrite = false;
            this.innerStoreIterator = this.innerStore.getRowIterator();
            this.innerRow = this.innerStoreIterator.next();
            this.outterRow = this.outterIter.next();
            int compareResult = this.compare(this.outterRow, this.innerRow);
            if (compareResult != 0) {
                this.closeInnerStore();
                this.innerRow = null;
            }
        } else {
            this.outterRow = null;
            this.innerRow = null;
        }
    }

    private void innerStoreNextRow() {
        if (this.innerStoreIterator.hasNext()) {
            this.innerRow = this.innerStoreIterator.next();
        } else if (this.outterIter.hasNext()) {
            this.compareOutterRowAndInnerStoreRow(false);
        } else {
            this.outterRow = null;
            this.innerRow = this.lastInnerRow;
        }
    }

    private void stillWriteInnerStore() {
        if (this.innerIter.hasNext()) {
            this.innerRow = this.innerIter.next();
            int compareResult = this.compare(this.outterRow, this.innerRow);
            if (compareResult == 0) {
                this.innerStore.write(this.innerRow);
            } else {
                this.lastInnerRow = this.innerRow;
                this.stillWrite = false;
                this.innerStoreIterator = this.innerStore.getRowIterator();
                this.innerRow = this.innerStoreIterator.next();
                this.nextOutterRow();
            }
        } else if (this.outterIter.hasNext()) {
            this.compareOutterRowAndInnerStoreRow(true);
        } else {
            this.outterRow = null;
            this.innerRow = null;
        }
    }

    private void compareOutterRowAndInnerStoreRow(boolean setInnerRowNull) {
        this.stillWrite = false;
        this.innerStoreIterator = this.innerStore.getRowIterator();
        this.innerRow = this.innerStoreIterator.next();
        this.outterRow = this.outterIter.next();
        int compareResult = this.compare(this.outterRow, this.innerRow);
        if (compareResult != 0) {
            this.innerRow = setInnerRowNull ? null : this.lastInnerRow;
            this.innerStore.close();
            this.innerStore = null;
            this.innerStoreIterator = null;
            this.stillWrite = false;
            this.lastInnerRow = null;
        }
    }

    private void init() {
        boolean innerIsEmpty;
        boolean outterIsEmpty = !this.outterIter.hasNext();
        boolean bl = innerIsEmpty = !this.innerIter.hasNext();
        if (outterIsEmpty && innerIsEmpty) {
            this.eof = true;
            return;
        }
        if (outterIsEmpty) {
            if (NotInnerType.Outter == this.nit) {
                this.eof = true;
            } else {
                this.initInner();
            }
            this.initFirst();
            return;
        }
        if (innerIsEmpty) {
            if (NotInnerType.Inner == this.nit) {
                this.eof = true;
            } else {
                this.initOutter();
            }
            this.initFirst();
            return;
        }
        this.initOutter();
        this.initInner();
        this.initFirst();
    }

    private void initOutter() {
        this.outterOrderStore = StoreFactory.createOrderStore(this.outterRowMeta, this.outterOrderItems);
        this.outterOrderStore.write(this.outterIter);
        this.outterIter = this.outterOrderStore.getRowIterator();
    }

    private void initInner() {
        this.innerOrderStore = StoreFactory.createOrderStore(this.innerRowMeta, this.innerOrderItems);
        this.innerOrderStore.write(this.innerIter);
        this.innerIter = this.innerOrderStore.getRowIterator();
    }

    private void initFirst() {
        if (this.outterIter.hasNext()) {
            this.outterRow = this.outterIter.next();
        }
        if (this.innerIter.hasNext()) {
            this.innerRow = this.innerIter.next();
        }
    }

    private int compare(Row outterRow, Row innerRow) {
        for (int i = 0; i < this.outterJoinOnColumns.length; ++i) {
            Object o2;
            Object o1 = outterRow.get(this.outterJoinOnColumns[i]);
            int r = AlgoUtil.compareValue(o1, o2 = innerRow.get(this.innerJoinOnColumns[i]));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.innerStore != null) {
                this.innerStore.close();
            }
            if (this.outterOrderStore != null) {
                this.outterOrderStore.close();
            }
            if (this.innerOrderStore != null) {
                this.innerOrderStore.close();
            }
            this.closed = true;
        }
    }
}

