/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.order;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.JoinHint;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.util.AlgoUtil;

public class OrderComparator
implements Comparator<Row> {
    private OrderItem[] orderItems1;
    private Calc[] calcs1;
    private Calc[] calcs2;
    private JoinHint joinHint;

    public OrderComparator(RowMeta rowMeta, OrderItem[] orderItems) {
        this(rowMeta, orderItems, rowMeta, orderItems);
    }

    public OrderComparator(RowMeta rowMeta1, OrderItem[] orderItems1, RowMeta rowMeta2, OrderItem[] orderItems2) {
        this(rowMeta1, orderItems1, rowMeta2, orderItems2, null);
    }

    public OrderComparator(RowMeta rowMeta1, OrderItem[] orderItems1, RowMeta rowMeta2, OrderItem[] orderItems2, JoinHint joinHint) {
        Preconditions.checkArgument((orderItems1.length == orderItems2.length ? 1 : 0) != 0);
        this.orderItems1 = orderItems1;
        this.joinHint = joinHint;
        ExprParser parser1 = new ExprParser(rowMeta1);
        this.calcs1 = new Calc[orderItems1.length];
        CompileContext cc1 = new CompileContext(rowMeta1, null);
        for (int i = 0; i < this.calcs1.length; ++i) {
            this.calcs1[i] = parser1.parse(orderItems1[i].expr).compile(cc1);
        }
        if (orderItems2 == orderItems1) {
            this.calcs2 = this.calcs1;
        } else {
            ExprParser parser2 = new ExprParser(rowMeta2);
            CompileContext cc2 = new CompileContext(rowMeta2, null);
            this.calcs2 = new Calc[orderItems2.length];
            for (int i = 0; i < this.calcs2.length; ++i) {
                this.calcs2[i] = parser2.parse(orderItems2[i].expr).compile(cc2);
            }
        }
    }

    public Object nullToZero(Object o) {
        if (o == null && this.joinHint != null && this.joinHint.isNullAsZero()) {
            return 0;
        }
        return o;
    }

    @Override
    public int compare(Row r1, Row r2) {
        for (int i = 0; i < this.orderItems1.length; ++i) {
            int r;
            Object o1 = this.nullToZero(this.calcs1[i].execute(r1, null));
            Object o2 = this.nullToZero(this.calcs2[i].execute(r2, null));
            if (o1 == null) {
                if (o2 == null) continue;
                return -1;
            }
            if (o2 == null) {
                return this.orderItems1[i].asc ? 1 : -1;
            }
            if (o1 instanceof Number && o2 instanceof Number) {
                r = AlgoUtil.compareNumber((Number)o1, (Number)o2);
                if (r == 0) continue;
                return this.orderItems1[i].asc ? r : -1 * r;
            }
            if (o1 instanceof Number && !(o2 instanceof Number)) {
                throw new AlgoException("Value not compatible," + o1 + "(" + o1.getClass() + ")<>" + o2 + "(" + o2.getClass() + ")");
            }
            if (!(o1 instanceof Number) && o2 instanceof Number) {
                throw new AlgoException("Value not compatible," + o1 + "(" + o1.getClass() + ")<>" + o2 + "(" + o2.getClass() + ")");
            }
            if (o1 instanceof Comparable) {
                r = ((Comparable)o1).compareTo(o2);
                if (r == 0) continue;
                return this.orderItems1[i].asc ? r : -1 * r;
            }
            throw new AlgoException("Value not be comparable:" + o1);
        }
        return 0;
    }
}

