/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.order;

import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;

public class OrderDataSet
extends AbstractDataSet {
    private OrderItem[] orderItems;
    private AbstractDataSet input;

    public OrderDataSet(AbstractDataSet child, OrderItem[] orderItems) {
        super("Order", child);
        this.orderItems = orderItems;
        this.rowMeta = child.getRowMeta();
    }

    public OrderDataSet(AbstractDataSet child, String[] exprs) {
        this(child, exprs, null);
    }

    public OrderDataSet(AbstractDataSet child, String[] exprs, boolean[] descs) {
        super("Order", child);
        this.orderItems = OrderItem.buildOrderItems(exprs, descs);
        this.rowMeta = child.getRowMeta();
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        return InnerRowIterator.wrapper(this.getStore0().getRowIterator());
    }

    private Store getStore0() {
        if (this.store == null) {
            this.input = this.getInput(0);
            this.store = StoreFactory.createOrderStore(this.rowMeta, this.orderItems);
            this.store.write(this.input.innerIterator());
            this.detachInputs(false);
        }
        return this.store;
    }

    @Override
    public boolean isEmpty() {
        return this.getStore0().size() == 0;
    }

    @Override
    public void realClose() {
        if (this.input != null) {
            this.input.close();
        }
    }
}

