/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.reduce;

import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.groupby.GroupbyInfo;
import kd.bos.algo.util.ArrayKey;

public class ReduceGroupDataSet
extends AbstractDataSet {
    private ReduceGroupFunction fun;
    private RowMeta rowMeta;
    private String[] groups;
    private DataSet orderDataSet;

    public ReduceGroupDataSet(AbstractDataSet dataSet, ReduceGroupFunction fun) {
        super("ReduceGroup", dataSet);
        this.fun = fun;
        this.rowMeta = fun.getResultRowMeta();
    }

    public ReduceGroupDataSet(AbstractDataSet dataSet, GroupbyInfo info, ReduceGroupFunction fun) {
        super("ReduceGroup", dataSet);
        this.fun = fun;
        this.groups = info.getGroups();
        this.rowMeta = fun.getResultRowMeta();
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet inner = this.getInput(0);
        InnerRowIterator iter = inner.innerIterator();
        if (this.groups == null) {
            Iterator<Object[]> resultIter = this.fun.reduce(iter);
            return InnerRowIterator.wrapperObjectArray(this.rowMeta, resultIter);
        }
        this.orderDataSet = inner.orderBy(this.groups);
        ReduceIterator result = new ReduceIterator();
        return InnerRowIterator.wrapper(result);
    }

    @Override
    public void realClose() {
        if (this.orderDataSet != null) {
            this.orderDataSet.close();
        }
    }

    class GroupSplit {
        private ArrayKey preKey = null;
        private ArrayKey currentKey = null;
        private Row currentRow;

        GroupSplit() {
        }

        Iterator<Row> nextGroup() {
            if (this.currentRow != null || ReduceGroupDataSet.this.orderDataSet.hasNext()) {
                GroupIterator ret = new GroupIterator();
                return ret;
            }
            return null;
        }

        public boolean currentRowIsNull() {
            return this.currentRow == null;
        }

        class GroupIterator
        implements Iterator<Row> {
            private GroupIterator() {
            }

            @Override
            public boolean hasNext() {
                if (GroupSplit.this.currentRow != null) {
                    return true;
                }
                if (ReduceGroupDataSet.this.orderDataSet.hasNext()) {
                    GroupSplit.this.currentRow = ReduceGroupDataSet.this.orderDataSet.next();
                    GroupSplit.this.currentKey = this.toKey(GroupSplit.this.currentRow);
                    if (GroupSplit.this.preKey == null) {
                        return true;
                    }
                    return GroupSplit.this.preKey.equals(GroupSplit.this.currentKey);
                }
                GroupSplit.this.currentRow = null;
                GroupSplit.this.currentKey = null;
                return false;
            }

            @Override
            public Row next() {
                Row ret = GroupSplit.this.currentRow;
                GroupSplit.this.currentRow = null;
                GroupSplit.this.preKey = GroupSplit.this.currentKey;
                GroupSplit.this.currentKey = null;
                return ret;
            }

            private ArrayKey toKey(Row row) {
                Object[] keys = new Object[ReduceGroupDataSet.this.groups.length];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = row.get(ReduceGroupDataSet.this.groups[i]);
                }
                return new ArrayKey(keys);
            }
        }
    }

    class ReduceIterator
    implements Iterator<Row> {
        GroupSplit groupSplit;
        private Iterator<Row> funIter;
        private boolean eof = false;

        public ReduceIterator() {
            this.groupSplit = new GroupSplit();
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.funIter == null) {
                this.initFunIter();
                if (this.funIter == null) {
                    this.eof = true;
                    return false;
                }
            }
            while (!(this.funIter.hasNext() || !ReduceGroupDataSet.this.orderDataSet.hasNext() && this.groupSplit.currentRowIsNull())) {
                this.initFunIter();
                if (this.funIter != null) continue;
                this.eof = true;
                return false;
            }
            return this.funIter.hasNext();
        }

        @Override
        public Row next() {
            return this.funIter.next();
        }

        private void initFunIter() {
            Iterator<Row> iter = this.groupSplit.nextGroup();
            if (iter == null) {
                this.funIter = null;
                this.eof = true;
            } else {
                this.funIter = InnerRowIterator.wrapperObjectArray(ReduceGroupDataSet.this.rowMeta, ReduceGroupDataSet.this.fun.reduce(iter));
            }
        }
    }
}

