/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.reduce;

import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.groupby.GroupbyInfo;
import kd.bos.algo.dataset.reduce.DataSetBuilderCollector;
import kd.bos.algo.util.ArrayKey;

public class ReduceGroupWithCollectDataSet
extends AbstractDataSet {
    private ReduceGroupFunctionWithCollector fun;
    private RowMeta rowMeta;
    private String[] groups;
    private DataSet orderDataSet;

    public ReduceGroupWithCollectDataSet(AbstractDataSet dataSet, ReduceGroupFunctionWithCollector fun) {
        super("ReduceGroup", dataSet);
        this.fun = fun;
        this.rowMeta = fun.getResultRowMeta();
    }

    public ReduceGroupWithCollectDataSet(AbstractDataSet dataSet, GroupbyInfo info, ReduceGroupFunctionWithCollector fun) {
        super("ReduceGroup", dataSet);
        this.fun = fun;
        this.groups = info.getGroups();
        this.rowMeta = fun.getResultRowMeta();
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet inner = this.getInput(0);
        InnerRowIterator iter = inner.innerIterator();
        if (this.groups == null) {
            DataSetBuilder builder = Algo.create("reduceGroupWithCollect").createDataSetBuilder(this.rowMeta);
            DataSetBuilderCollector myCollector = new DataSetBuilderCollector(builder);
            this.fun.reduce(iter, myCollector);
            return InnerRowIterator.wrapper(builder.build().iterator());
        }
        this.orderDataSet = inner.orderBy(this.groups);
        ReduceIterator result = new ReduceIterator();
        return InnerRowIterator.wrapper(result);
    }

    @Override
    public void realClose() {
        if (this.orderDataSet != null) {
            this.orderDataSet.close();
        }
    }

    class GroupSplit {
        private ArrayKey preKey = null;
        private ArrayKey currentKey = null;
        private Row currentRow;

        GroupSplit() {
        }

        Iterator<Row> nextGroup() {
            if (this.currentRow != null || ReduceGroupWithCollectDataSet.this.orderDataSet.hasNext()) {
                GroupIterator ret = new GroupIterator();
                return ret;
            }
            return null;
        }

        public boolean currentRowIsNull() {
            return this.currentRow == null;
        }

        class GroupIterator
        implements Iterator<Row> {
            private GroupIterator() {
            }

            @Override
            public boolean hasNext() {
                if (GroupSplit.this.currentRow != null) {
                    return true;
                }
                if (ReduceGroupWithCollectDataSet.this.orderDataSet.hasNext()) {
                    GroupSplit.this.currentRow = ReduceGroupWithCollectDataSet.this.orderDataSet.next();
                    GroupSplit.this.currentKey = this.toKey(GroupSplit.this.currentRow);
                    if (GroupSplit.this.preKey == null) {
                        return true;
                    }
                    return GroupSplit.this.preKey.equals(GroupSplit.this.currentKey);
                }
                GroupSplit.this.currentRow = null;
                GroupSplit.this.currentKey = null;
                return false;
            }

            @Override
            public Row next() {
                Row ret = GroupSplit.this.currentRow;
                GroupSplit.this.currentRow = null;
                GroupSplit.this.preKey = GroupSplit.this.currentKey;
                GroupSplit.this.currentKey = null;
                return ret;
            }

            private ArrayKey toKey(Row row) {
                Object[] keys = new Object[ReduceGroupWithCollectDataSet.this.groups.length];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = row.get(ReduceGroupWithCollectDataSet.this.groups[i]);
                }
                return new ArrayKey(keys);
            }
        }
    }

    class ReduceIterator
    implements Iterator<Row> {
        GroupSplit groupSplit;
        private Iterator<Row> funIter;
        private boolean eof = false;

        public ReduceIterator() {
            this.groupSplit = new GroupSplit();
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.funIter == null) {
                this.initFunIter();
                if (this.funIter == null) {
                    this.eof = true;
                    return false;
                }
            }
            while (!(this.funIter.hasNext() || !ReduceGroupWithCollectDataSet.this.orderDataSet.hasNext() && this.groupSplit.currentRowIsNull())) {
                this.initFunIter();
                if (this.funIter != null) continue;
                this.eof = true;
                return false;
            }
            return this.funIter.hasNext();
        }

        @Override
        public Row next() {
            return this.funIter.next();
        }

        private void initFunIter() {
            Iterator<Row> iter = this.groupSplit.nextGroup();
            if (iter == null) {
                this.funIter = null;
                this.eof = true;
            } else {
                DataSetBuilder builder = Algo.create("reduceGroupWithCollect").createDataSetBuilder(ReduceGroupWithCollectDataSet.this.rowMeta);
                DataSetBuilderCollector myCollector = new DataSetBuilderCollector(builder);
                ReduceGroupWithCollectDataSet.this.fun.reduce(iter, myCollector);
                this.funIter = myCollector.getResultDataSet();
            }
        }
    }
}

