/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.schema;

import com.google.common.base.Joiner;
import java.util.HashMap;
import kd.bos.algo.AlgoException;
import kd.bos.algo.sql.schema.Column;
import kd.bos.algo.sql.schema.FuncFactory;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.schema.Table;
import kd.bos.algo.sql.tree.func.FormulaFuncFactory;

public class RegisterSchema
implements Schema {
    private HashMap<String, Table> relationMap = new HashMap();
    private FuncFactory funcFactory;
    private boolean ignoreCase;

    public RegisterSchema() {
        this(new FormulaFuncFactory());
    }

    public RegisterSchema(FuncFactory funcFactory) {
        this(funcFactory, true);
    }

    public RegisterSchema(FuncFactory funcFactory, boolean ignoreCase) {
        this.funcFactory = funcFactory;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public String getName() {
        return "default";
    }

    private String makeKey(String key) {
        return this.ignoreCase ? key.toUpperCase() : key;
    }

    public void registerRelation(Table relation) {
        this.relationMap.put(this.makeKey(relation.getName()), relation);
    }

    public Object lookup(String[] nameParts) {
        return this.lookup(nameParts, null);
    }

    public Object lookup(String[] nameParts, Class<?> clazz) {
        switch (nameParts.length) {
            case 0: {
                return null;
            }
            case 1: {
                return this.lookup1(this.makeKey(nameParts[0]), null);
            }
            case 2: {
                Table rel = this.relationMap.get(this.makeKey(nameParts[0]));
                return rel == null ? null : rel.lookupColumn(nameParts[1]);
            }
        }
        return null;
    }

    private Object lookup1(String key, Class<?> clazz) {
        if (clazz == null) {
            Table relation = this.relationMap.get(key);
            if (relation != null) {
                return relation;
            }
            return this.lookup1Column(key);
        }
        if (Table.class.isAssignableFrom(clazz)) {
            return this.relationMap.get(key);
        }
        return this.lookup1Column(key);
    }

    private Column lookup1Column(String key) {
        Column column = null;
        for (Table rel : this.relationMap.values()) {
            Column c = rel.lookupColumn(key);
            if (column != null) {
                throw new AlgoException("Ambiguous key:" + key);
            }
            column = c;
        }
        return column;
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public Table getTable(String name) {
        return this.relationMap.get(this.makeKey(name));
    }

    @Override
    public Column getColumn(String[] nameParts) {
        switch (nameParts.length) {
            case 0: {
                return null;
            }
            case 1: {
                return this.lookup1Column(this.makeKey(nameParts[0]));
            }
        }
        Table rel = this.relationMap.get(this.makeKey(nameParts[0]));
        Column column = null;
        if (rel != null) {
            column = rel.lookupColumn(nameParts[1]);
        }
        if (column == null) {
            column = this.lookup1Column(Joiner.on((String)".").join((Object[])nameParts));
        }
        return column;
    }

    @Override
    public FuncFactory getFuncFactory() {
        return this.funcFactory;
    }

    @Override
    public Table[] getTables() {
        return this.relationMap.values().toArray(new Table[0]);
    }
}

