/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.select;

import java.util.HashSet;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.SettableArrayRow;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;

public class SelectDataSet
extends AbstractDataSet {
    private Alias[] exprs;
    private boolean hasPreRowExpr;
    private Calc[] calcs;
    private SettableArrayRow cacheRow;
    private RowMeta innerRowMeta;

    public SelectDataSet(AbstractDataSet dataSet, Alias[] exprs, boolean hasPreRowExpr) {
        super("Select", dataSet);
        this.exprs = exprs;
        this.hasPreRowExpr = hasPreRowExpr;
        this.innerRowMeta = dataSet.getRowMeta();
        this.rowMeta = this.createTargetRowMeta();
    }

    private RowMeta buildRowMeta() {
        AbstractDataSet dataSet = this.getInput(0);
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] targetFields = new Field[this.exprs.length];
        for (int i = 0; i < this.exprs.length; ++i) {
            DataType dataType = this.exprs[i].getDataType();
            targetFields[i] = new Field(this.exprs[i].getAlias(), dataType);
        }
        this.checkDuplicateName(targetFields);
        RowMeta result = new RowMeta(targetFields);
        CompileContext cc = new CompileContext(rowMeta, result);
        this.calcs = new Calc[this.exprs.length];
        for (int i = 0; i < this.exprs.length; ++i) {
            this.calcs[i] = this.exprs[i].compile(cc);
        }
        return result;
    }

    private void checkDuplicateName(Field[] targetFields) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < targetFields.length; ++i) {
            if (set.add(targetFields[i].getAlias())) continue;
            throw new AlgoException("Duplicated field: " + targetFields[i].getAlias());
        }
    }

    @Override
    public final RowMeta createTargetRowMeta() {
        return this.buildRowMeta();
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet dataSet = this.getInput(0);
        final InnerRowIterator iter = dataSet.innerIterator();
        this.cacheRow = new SettableArrayRow(this.rowMeta);
        final SettableArrayRow preRow = new SettableArrayRow(this.rowMeta);
        return new InnerRowIterator(){

            @Override
            public boolean _hasNext() {
                return iter.hasNext();
            }

            @Override
            public Row _next() {
                Row row = (Row)iter.next();
                Row result = SelectDataSet.this.convertRow(SelectDataSet.this.cacheRow, SelectDataSet.this.calcs, SelectDataSet.this.innerRowMeta, row, SelectDataSet.this.hasPreRowExpr ? preRow : null, SelectDataSet.this.rowMeta);
                if (SelectDataSet.this.hasPreRowExpr) {
                    for (int i = 0; i < SelectDataSet.this.cacheRow.size(); ++i) {
                        preRow.setValue(i, SelectDataSet.this.cacheRow.get(i));
                    }
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void realClose() {
    }

    private Row convertRow(SettableArrayRow row, Calc[] calcs, RowMeta innerRowMeta, Row innerRow, Row preRow, RowMeta targetRowType) {
        for (int i = 0; i < calcs.length; ++i) {
            row.setValue(i, calcs[i].execute(innerRow, preRow));
        }
        return row;
    }
}

