/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.split.bygroup;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.env.Environment;

public class SplitByGroupDataSetBuilder {
    private String[] groupFields;
    private RowMeta rowMeta;
    private AbstractDataSet dataSet;

    public SplitByGroupDataSetBuilder(AbstractDataSet dataSet, String[] groupFields) {
        this.groupFields = groupFields;
        this.rowMeta = dataSet.getRowMeta();
        this.dataSet = dataSet;
    }

    public DataSet[] split() {
        Map<String, DataSetBuilder> builderMap = this.buildDataSetBuilders(this.groupFields);
        DataSet[] dataSets = new DataSet[builderMap.size()];
        Iterator<Map.Entry<String, DataSetBuilder>> iterator = builderMap.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            dataSets[i] = iterator.next().getValue().build();
            ++i;
        }
        return dataSets;
    }

    private Map<String, DataSetBuilder> buildDataSetBuilders(String[] groupFields) {
        HashMap<String, DataSetBuilder> builderMap = new HashMap<String, DataSetBuilder>();
        if (this.dataSet == null) {
            return builderMap;
        }
        int maxSize = AlgoConfiguration.SPLIT_BYGROUP_MAXSIZE.getInt();
        Environment algo = this.dataSet.getEnvironment();
        StringBuilder builder = new StringBuilder();
        while (this.dataSet.hasNext()) {
            Row next = this.dataSet.next();
            for (String field : groupFields) {
                builder.append(next.get(field)).append("`");
            }
            String key = builder.toString();
            DataSetBuilder dataSetBuilder = (DataSetBuilder)builderMap.get(key);
            if (dataSetBuilder != null) {
                dataSetBuilder.append(next);
            } else {
                dataSetBuilder = algo.createDataSetBuilder(this.rowMeta);
                builderMap.put(key, dataSetBuilder);
                dataSetBuilder.append(next);
            }
            builder.delete(0, builder.length());
            if (builderMap.size() <= maxSize) continue;
            throw new AlgoException("splitByGroup exceed max group size:" + maxSize);
        }
        if (this.dataSet != null) {
            this.dataSet.close();
        }
        return builderMap;
    }
}

