/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.sql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.algo.SqlHint;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.sql.parser.SqlParser;
import kd.bos.algo.sql.tree.AllColumns;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.GroupBy;
import kd.bos.algo.sql.tree.GroupingElement;
import kd.bos.algo.sql.tree.Limit;
import kd.bos.algo.sql.tree.Literal;
import kd.bos.algo.sql.tree.OrderBy;
import kd.bos.algo.sql.tree.Query;
import kd.bos.algo.sql.tree.QueryBody;
import kd.bos.algo.sql.tree.QuerySpecification;
import kd.bos.algo.sql.tree.Select;
import kd.bos.algo.sql.tree.SelectItem;
import kd.bos.algo.sql.tree.SingleColumn;
import kd.bos.algo.sql.tree.SortItem;
import kd.bos.algo.sql.tree.Statement;
import kd.bos.algo.sql.tree.UnresolvedAttribute;
import kd.bos.algo.sql.tree.UnresolvedFuncall;
import kd.bos.algo.util.Aggregator;

public class SqlDataSet
extends AbstractDataSet {
    private String sql;
    private String[] groupFields;
    private ArrayList<String> selects = new ArrayList();
    private boolean hasSimpleFieldAfterAggField = false;
    private DataSet innerDataSet;
    private SqlHint hint;

    public SqlDataSet(AbstractDataSet dataset, String sql, SqlHint hint) {
        super("sql", dataset);
        this.sql = sql;
        this.hint = hint;
        this.build(dataset);
    }

    private void build(DataSet dataset) {
        Optional<Limit> optLimit;
        Optional<OrderBy> optOrderBy;
        Optional<GroupBy> optGrp;
        SqlParser parser = new SqlParser();
        Statement stmt = parser.parseStatement(this.sql);
        Query query = (Query)stmt;
        QueryBody queryBody = query.getQueryBody();
        if (!(queryBody instanceof QuerySpecification)) {
            throw new AlgoException("Illegal sql query statment:" + this.sql);
        }
        QuerySpecification qs = (QuerySpecification)queryBody;
        Optional<Expr> opt = qs.getWhere();
        if (opt.isPresent()) {
            dataset = dataset.filter(opt.get().toString());
        }
        dataset = (optGrp = qs.getGroupBy()).isPresent() ? this.buildGroupBy(dataset, optGrp.get(), qs) : this.buildSelect(dataset, qs);
        Optional<Expr> optHaving = qs.getHaving();
        if (optHaving.isPresent()) {
            dataset = this.buildHaving(dataset, optHaving.get());
        }
        if ((optOrderBy = qs.getOrderBy()).isPresent()) {
            dataset = this.buildOrderBy(dataset, optOrderBy.get());
        }
        if ((optLimit = qs.getLimit()).isPresent()) {
            dataset = dataset.limit(optLimit.get().getStart(), optLimit.get().getLength());
        }
        this.innerDataSet = dataset;
    }

    private DataSet buildHaving(DataSet dataset, Expr expr) {
        return ((AbstractDataSet)dataset).filter(expr);
    }

    private DataSet buildOrderBy(DataSet dataset, OrderBy orderBy) {
        List<SortItem> list = orderBy.getSortItems();
        int len = list.size();
        String[] orders = new String[len];
        for (int i = 0; i < len; ++i) {
            orders[i] = list.get(i).sql();
        }
        return dataset.orderBy(orders);
    }

    private DataSet buildSelect(DataSet dataset, QuerySpecification qs) {
        Select select = qs.getSelect();
        List<SelectItem> items = select.getSelectItems();
        boolean hasAgg = false;
        boolean hasAttribute = false;
        boolean hasAll = false;
        for (SelectItem item : items) {
            if (item instanceof AllColumns) {
                hasAll = true;
                continue;
            }
            SingleColumn column = (SingleColumn)item;
            Expr expr = column.getExpression();
            if (expr instanceof UnresolvedFuncall) {
                UnresolvedFuncall funcall = (UnresolvedFuncall)expr;
                String funcName = funcall.getName();
                if (!this.isAggregator(funcName)) continue;
                hasAgg = true;
                continue;
            }
            if (!(expr instanceof UnresolvedAttribute)) continue;
            hasAttribute = true;
        }
        if (hasAgg) {
            if (hasAll) {
                throw new AlgoException("Illegal '*' in aggregation statement, sql is: " + this.sql);
            }
            if (hasAttribute) {
                throw new AlgoException("Only aggregator expressions supported in aggregation statement, sql is: " + this.sql);
            }
            return this.buildSingleGroupBy(dataset, qs);
        }
        return this.buildSimpleSelect(dataset, qs);
    }

    private DataSet buildSimpleSelect(DataSet dataset, QuerySpecification qs) {
        Select select = qs.getSelect();
        List<SelectItem> items = select.getSelectItems();
        ArrayList<String> selects = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        for (SelectItem item : items) {
            if (item instanceof AllColumns) {
                for (String field : dataset.getRowMeta().getFieldNames()) {
                    if (!set.add(field)) {
                        throw new AlgoException("Duplicated field: " + field + ", sql is: " + this.sql);
                    }
                    selects.add(field);
                }
                continue;
            }
            SingleColumn column = (SingleColumn)item;
            selects.add(column.toString());
        }
        return dataset.select(select.isDistinct(), selects.toArray(new String[selects.size()]));
    }

    private DataSet buildSingleGroupBy(DataSet dataset, QuerySpecification qs) {
        GroupbyDataSet gds = dataset.groupBy(null);
        Select select = qs.getSelect();
        List<SelectItem> items = select.getSelectItems();
        boolean hasNotAggField = false;
        for (SelectItem item : items) {
            if (item instanceof AllColumns) {
                throw new AlgoException("Not support * in group by statement: " + this.sql);
            }
            SingleColumn column = (SingleColumn)item;
            Expr expr = column.getExpression();
            if (expr instanceof UnresolvedFuncall) {
                Expr child;
                UnresolvedFuncall funcall = (UnresolvedFuncall)expr;
                String funcName = funcall.getName();
                String[] fields = funcall.getArguments();
                String child2 = null;
                if (funcall.getChildrenCount() > 1 && (child = funcall.getChild(1)) instanceof Literal) {
                    Literal child1 = (Literal)child;
                    child2 = child1.getValue().toString();
                }
                gds = this.addGroupSelect(dataset, gds, funcName, fields, column.getAlias().orElse(null), child2, funcall.isDistinct());
                continue;
            }
            this.selects.add(column.sql());
            hasNotAggField = true;
        }
        DataSet result = gds.finish();
        if (hasNotAggField) {
            result = result.select(select.isDistinct(), this.selects.toArray(new String[this.selects.size()]));
        }
        return result;
    }

    private boolean isAggregator(String funcName) {
        if (this.hint.getAggFunction(funcName) != null) {
            return true;
        }
        return Aggregator.isAggregator(funcName);
    }

    private DataSet buildGroupBy(DataSet dataset, GroupBy groupBy, QuerySpecification qs) {
        GroupingElement ge = groupBy.getGroupingElements().get(0);
        this.groupFields = new String[ge.getChildren().size()];
        for (int i = 0; i < this.groupFields.length; ++i) {
            this.groupFields[i] = ge.getChildren().get(i).toString();
        }
        GroupbyDataSet gds = dataset.groupBy(this.groupFields);
        Select select = qs.getSelect();
        List<SelectItem> items = select.getSelectItems();
        boolean hasUnresolvedFuncall = false;
        for (SelectItem item : items) {
            if (item instanceof AllColumns) {
                throw new AlgoException("Not support * in group by statement: " + this.sql);
            }
            SingleColumn column = (SingleColumn)item;
            Expr expr = column.getExpression();
            if (expr instanceof UnresolvedFuncall) {
                Expr child;
                hasUnresolvedFuncall = true;
                UnresolvedFuncall funcall = (UnresolvedFuncall)expr;
                String funcName = funcall.getName();
                String[] fields = funcall.getArguments();
                String child2 = null;
                if (funcall.getChildrenCount() > 1 && (child = funcall.getChild(1)) instanceof Literal) {
                    Literal child1 = (Literal)child;
                    child2 = child1.getValue().toString();
                }
                gds = this.addGroupSelect(dataset, gds, funcName, fields, column.getAlias().orElse(null), child2, funcall.isDistinct());
                continue;
            }
            if (expr instanceof UnresolvedAttribute) {
                if (hasUnresolvedFuncall) {
                    this.hasSimpleFieldAfterAggField = true;
                }
                String field = ((UnresolvedAttribute)expr).sql();
                gds = this.addGroupSelect(dataset, gds, field, column.getAlias().orElse(null));
                continue;
            }
            this.selects.add(column.sql());
        }
        DataSet result = gds.finish();
        if (this.notEqualsSelect()) {
            result = result.select(this.selects.toArray(new String[this.selects.size()]));
        }
        return result;
    }

    private boolean notEqualsSelect() {
        if (this.hasSimpleFieldAfterAggField) {
            return true;
        }
        for (int i = 0; i < this.groupFields.length; ++i) {
            if (this.groupFields[i].equals(this.selects.get(i))) continue;
            return true;
        }
        return false;
    }

    private GroupbyDataSet addGroupSelect(DataSet dataset, GroupbyDataSet gds, String field, String alias) {
        try {
            dataset.getRowMeta().getField(field);
        }
        catch (AlgoException e) {
            throw new AlgoException(e, e.getMessage() + ", sql is " + this.sql, new Object[0]);
        }
        boolean found = false;
        for (int i = 0; i < this.groupFields.length; ++i) {
            if (!this.groupFields[i].equalsIgnoreCase(field)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new AlgoException("Select field '" + field + "' is illegal or not in group by fields, sql is " + this.sql);
        }
        this.selects.add(alias == null ? field : alias);
        return gds;
    }

    private String buildExpr(String[] fields) {
        StringBuilder expr = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            expr.append(fields[i]);
            if (i >= fields.length - 1) continue;
            expr.append(",");
        }
        return expr.toString();
    }

    private GroupbyDataSet addGroupSelect(DataSet dataset, GroupbyDataSet gds, String funcName, String[] fields, String alias, String child2, boolean isDistinct) {
        if (funcName.equalsIgnoreCase("count")) {
            if (isDistinct) {
                gds = alias != null ? gds.countDistinct(fields, alias) : gds.countDistinct(fields);
                this.selects.add(alias == null ? (fields.length > 1 ? "countdistinct" : fields[0]) : alias);
                return gds;
            }
            gds = alias != null ? gds.count(alias) : gds.count();
            this.selects.add(alias == null ? "count" : alias);
            return gds;
        }
        if (funcName.equalsIgnoreCase("sum")) {
            gds = alias != null ? gds.sum(fields[0], alias) : gds.sum(fields[0]);
        } else if (funcName.equalsIgnoreCase("max")) {
            gds = alias != null ? gds.max(fields[0], alias) : gds.max(fields[0]);
        } else if (funcName.equalsIgnoreCase("min")) {
            gds = alias != null ? gds.min(fields[0], alias) : gds.min(fields[0]);
        } else if (funcName.equalsIgnoreCase("avg")) {
            gds = alias != null ? gds.avg(fields[0], alias) : gds.avg(fields[0]);
        } else if (funcName.equalsIgnoreCase("group_concat")) {
            gds = alias != null ? gds.groupConcat(fields[0], alias, child2) : gds.groupConcat(fields[0], null, child2);
        } else if (funcName.equalsIgnoreCase("countdistinct")) {
            gds = alias != null ? gds.countDistinct(fields, alias) : gds.countDistinct(fields);
        } else if (this.hint.containsAggFunction(funcName)) {
            gds = alias != null ? gds.agg(this.hint.getAggFunction(funcName), fields[0], alias) : gds.agg(this.hint.getAggFunction(funcName), fields[0], fields[0]);
        } else {
            throw new AlgoException("Not support aggregate function: " + funcName);
        }
        this.selects.add(alias == null ? fields[0] : alias);
        return gds;
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        return this.innerDataSet.getRowMeta();
    }

    @Override
    protected InnerRowIterator createIterator() {
        return ((AbstractDataSet)this.innerDataSet).innerIterator();
    }

    @Override
    public void realClose() {
        if (this.innerDataSet != null) {
            this.innerDataSet.close();
        }
    }
}

