/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store;

import java.util.ArrayList;
import java.util.Comparator;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.store.HashMapStore;
import kd.bos.algo.dataset.store.ListStore;
import kd.bos.algo.dataset.store.MultiValueMapStore;
import kd.bos.algo.dataset.store.SortableStore;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreCopyWrapper;
import kd.bos.algo.dataset.store.heaplimit.HeapStoreFactory;
import kd.bos.algo.dataset.store.heaplimit.SequenceStore;
import kd.bos.algo.dataset.store.heaplimit.SimpleHashMapStore;
import kd.bos.algo.dataset.store.heaplimit.SimpleMultiValueMapStore;
import kd.bos.algo.dataset.store.heaplimit.TashaOrderStore;
import kd.bos.algo.dataset.store.mm.MMFactory;
import kd.bos.algo.dataset.store.mm.MMOrderStore;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.env.ThreadContext;

public abstract class StoreFactory {
    private static StoreFactory instance0 = StoreFactory.createStoreFactoryImpl0();
    private static StoreFactory instanceMM = StoreFactory.createStoreFactoryMM();

    protected abstract <K, V> HashMapStore<K, V> _createHashMapStore(int var1);

    protected abstract <K, V> MultiValueMapStore<K, V> _createMultiValueMapStore(int var1);

    protected abstract Store _createDataSetBackStore(RowMeta var1);

    protected abstract Store _createMergeJoinBufferStore(RowMeta var1);

    protected abstract SortableStore _createSortBufferStore(RowMeta var1, Comparator<Row> var2);

    protected abstract Store _createOrderStore(RowMeta var1, OrderItem[] var2);

    protected abstract Store _createStandaloneDataSetBackStore(RowMeta var1);

    private static StoreFactory createStoreFactoryImpl0() {
        return new StoreFactoryHeapLimit();
    }

    private static StoreFactory createStoreFactoryMM() {
        return new StoreFactoryMM();
    }

    private static StoreFactory getInstance() {
        String v = ThreadContext.getCurrent().getProperty("algo.mm.enable");
        boolean mmEnable = v != null ? Boolean.parseBoolean(v) : AlgoConfiguration.MM_ENABLE.getBoolean();
        return mmEnable ? instanceMM : instance0;
    }

    public static <K, V> HashMapStore<K, V> createHashMapStore(int fieldCount) {
        return StoreFactory.getInstance()._createHashMapStore(fieldCount);
    }

    public static <K, V> MultiValueMapStore<K, V> createMultiValueMapStore(int fieldCount) {
        return StoreFactory.getInstance()._createMultiValueMapStore(fieldCount);
    }

    public static Store createDataSetBackStore(RowMeta rowMeta) {
        return StoreFactory.getInstance()._createDataSetBackStore(rowMeta);
    }

    public static Store createStandaloneDataSetBackStore(RowMeta rowMeta) {
        return StoreFactory.getInstance()._createStandaloneDataSetBackStore(rowMeta);
    }

    public static Store createMergeJoinBufferStore(RowMeta rowMeta) {
        return StoreFactory.getInstance()._createMergeJoinBufferStore(rowMeta);
    }

    public static SortableStore createSortBufferStore(RowMeta rowMeta, Comparator<Row> comparator) {
        return StoreFactory.getInstance()._createSortBufferStore(rowMeta, comparator);
    }

    public static Store createOrderStore(RowMeta rowMeta, OrderItem[] orderItems) {
        return StoreFactory.getInstance()._createOrderStore(rowMeta, orderItems);
    }

    static class StoreFactoryHeapLimit
    extends StoreFactory {
        StoreFactoryHeapLimit() {
        }

        @Override
        protected <K, V> HashMapStore<K, V> _createHashMapStore(int fieldCount) {
            return new SimpleHashMapStore();
        }

        @Override
        protected <K, V> MultiValueMapStore<K, V> _createMultiValueMapStore(int fieldCount) {
            return new SimpleMultiValueMapStore();
        }

        @Override
        public Store _createDataSetBackStore(RowMeta rowMeta) {
            return new SequenceStore(rowMeta);
        }

        @Override
        protected Store _createStandaloneDataSetBackStore(RowMeta rowMeta) {
            return new SequenceStore(rowMeta, true);
        }

        @Override
        public Store _createMergeJoinBufferStore(RowMeta rowMeta) {
            return new SequenceStore(rowMeta, HeapStoreFactory.createHeapMergeJoinStore(), false);
        }

        @Override
        protected SortableStore _createSortBufferStore(RowMeta rowMeta, Comparator<Row> comparator) {
            return new ListStore(rowMeta, comparator);
        }

        @Override
        public Store _createOrderStore(RowMeta rowMeta, OrderItem[] orderItems) {
            ArrayList<OrderItem> notNullOrderItems = new ArrayList<OrderItem>();
            for (int i = 0; i < orderItems.length; ++i) {
                DataType dataType = rowMeta.getField(orderItems[i].expr).getDataType();
                if (dataType instanceof NullType) continue;
                notNullOrderItems.add(orderItems[i]);
            }
            if (notNullOrderItems.size() > 0) {
                orderItems = notNullOrderItems.toArray(new OrderItem[notNullOrderItems.size()]);
                return new StoreCopyWrapper(new TashaOrderStore(rowMeta, orderItems));
            }
            return new SequenceStore(rowMeta);
        }
    }

    static class StoreFactoryMM
    extends StoreFactory {
        StoreFactoryMM() {
        }

        @Override
        protected <K, V> HashMapStore<K, V> _createHashMapStore(int fieldCount) {
            return MMFactory.getMemAllocator().allocateHashMapStore(fieldCount);
        }

        @Override
        protected <K, V> MultiValueMapStore<K, V> _createMultiValueMapStore(int fieldCount) {
            return MMFactory.getMemAllocator().allocateMultiValueMapStore(fieldCount);
        }

        @Override
        protected Store _createDataSetBackStore(RowMeta rowMeta) {
            return MMFactory.createBackStore(rowMeta);
        }

        @Override
        protected Store _createStandaloneDataSetBackStore(RowMeta rowMeta) {
            return MMFactory.createStandaloneBackStore(rowMeta);
        }

        @Override
        protected Store _createMergeJoinBufferStore(RowMeta rowMeta) {
            return MMFactory.createBackStore(rowMeta);
        }

        @Override
        protected SortableStore _createSortBufferStore(RowMeta rowMeta, Comparator<Row> comparator) {
            return MMFactory.createMemeryBufferStore(rowMeta, comparator);
        }

        @Override
        protected Store _createOrderStore(RowMeta rowMeta, OrderItem[] orderItems) {
            ArrayList<OrderItem> notNullOrderItems = new ArrayList<OrderItem>();
            for (int i = 0; i < orderItems.length; ++i) {
                DataType dataType = rowMeta.getField(orderItems[i].expr).getDataType();
                if (dataType instanceof NullType) continue;
                notNullOrderItems.add(orderItems[i]);
            }
            if (notNullOrderItems.size() > 0) {
                orderItems = notNullOrderItems.toArray(new OrderItem[notNullOrderItems.size()]);
                return new StoreCopyWrapper(new MMOrderStore(rowMeta, orderItems));
            }
            return MMFactory.createBackStore(rowMeta);
        }
    }
}

